package org.cocos2d.protocols;

import org.cocos2d.types.ccBlendFunc;

/**
 * Specify the blending function according glBlendFunc
 * Please refer to glBlendFunc in OpenGL ES Manual
 * http://www.khronos.org/opengles/sdk/docs/man/xhtml/glBlendFunc.xml for more details.
 */
public interface CCBlendProtocol {
	/**
	 * Sets the source blending function.
	 *
	 * @param blendFunc A structure with source and destination factor to specify pixel arithmetic, 
	 *                  e.g. {GL_ONE, GL_ONE}, {GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA}.
	 *
	 */
	public void setBlendFunc(ccBlendFunc blendFunc);

	/**
	 * Returns the blending function that is currently being used.
	 * 
	 * @return A ccBlendFunc structure with source and destination factor which specified pixel arithmetic.
	 */
	public ccBlendFunc getBlendFunc();
}
