package org.cocos2d.tests;

import org.cocos2d.CCDirector;
import org.cocos2d.events.CCTouchDispatcher;
import org.cocos2d.layers.CCColorLayer;
import org.cocos2d.layers.CCLayer;
import org.cocos2d.layers.CCScene;
import org.cocos2d.lib.Cocos2dActivity;
import org.cocos2d.menus.CCMenu;
import org.cocos2d.menus.CCMenuItemFont;
import org.cocos2d.nodes.CCLabel;
import org.cocos2d.transitions.CCFlipXTransition;
import org.cocos2d.transitions.CCSlideInTTransition;
import org.cocos2d.transitions.CCTransitionScene;
import org.cocos2d.types.CGPoint;
import org.cocos2d.types.ccColor4B;

import android.os.Bundle;
import android.view.MotionEvent;


public class SceneTest extends Cocos2dActivity {
	// private static final String TAG = SceneTest.class.getSimpleName();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// set landscape mode
		CCDirector.sharedDirector().setLandscape(false);

		// show Stats
		CCDirector.sharedDirector().setDisplayStats(true);

		// frames per second
		CCDirector.sharedDirector().setAnimationInterval(1.0f / 60.0f);

		CCScene scene = CCScene.node();
		scene.addChild(new Layer1(), 0);

		// Make the Scene active
		CCDirector.sharedDirector().runWithScene(scene);
	}

	static class Layer1 extends CCLayer {
		public Layer1() {
			CCMenuItemFont item1 = CCMenuItemFont.create("Test pushScene", this, "onPushScene");
			CCMenuItemFont item2 = CCMenuItemFont.create("Test pushScene w/transition", this, "onPushSceneTran");
			CCMenuItemFont item3 = CCMenuItemFont.create("Quit", this, "onQuit");

			CCMenu menu = CCMenu.create(item1, item2, item3);
			menu.alignItemsVertically();

			addChild(menu);
		}

		public void onPushScene(Object sender) {
			CCScene scene = CCScene.node();
			scene.addChild(new Layer2(), 0);
			CCDirector.sharedDirector().pushScene(scene);
		}

		public void onPushSceneTran(Object sender) {
			CCScene scene = CCScene.node();
			scene.addChild(new Layer2(), 0);
			CCDirector.sharedDirector().pushScene(CCSlideInTTransition.transition(1, scene));
		}

		public void onQuit(Object sender) {
			CCDirector.sharedDirector().popScene();
		}

		public void onVoid() {
		}
	}

	static class Layer2 extends CCLayer {
		public Layer2() {
			CCMenuItemFont item1 = CCMenuItemFont.create("Replace Scene", this, "onReplaceScene");
			CCMenuItemFont item2 = CCMenuItemFont.create("Replace Scene Transition", this, "onReplaceSceneTransition");
			CCMenuItemFont item3 = CCMenuItemFont.create("Go Back", this, "onGoBack");

			CCMenu menu = CCMenu.create(item1, item2, item3);
			menu.alignItemsVertically();

			addChild(menu);
		}

		public void onGoBack(Object sender) {
			CCDirector.sharedDirector().popScene();
		}

		public void onReplaceScene(Object sender) {
			CCScene scene = CCScene.node();
			scene.addChild(new Layer3(), 0);
			CCDirector.sharedDirector().replaceScene(scene);
		}

		public void onReplaceSceneTransition(Object sender) {
			CCScene s = CCScene.node();
			s.addChild(new Layer3(), 0);
			CCDirector.sharedDirector().replaceScene(CCFlipXTransition.transition(2.0f, s, CCTransitionScene.tOrientation.kOrientationLeftOver));
		}
	}

	static class Layer3 extends CCColorLayer {
		public Layer3() {
			super(new ccColor4B(0, 0, 255, 255));

			isTouchEnabled_ = true;

			CCLabel label = CCLabel.makeLabel("Touch to pop scene", "DroidSans", 32);
			addChild(label);
			float width = CCDirector.sharedDirector().getWinSizeInPixels().width;
			float height = CCDirector.sharedDirector().getWinSizeInPixels().height;
			label.setPosition(CGPoint.make(width / 2, height / 2));
		}

		@Override
		public boolean ccTouchesEnded(MotionEvent event) {
			CCDirector.sharedDirector().popScene();
			return CCTouchDispatcher.kEventHandled;
		}
	}
}
