/****************************************************************************
Copyright (c) 2010-2013 cocos2d-x.org

http://www.cocos2d-x.org

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 ****************************************************************************/

package org.cocos2d.lib;

import java.io.UnsupportedEncodingException;
import java.util.Locale;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

public class Cocos2dHelper {
	// ===========================================================
	// Constants
	// ===========================================================
	private static final String PREFS_NAME = "Cocos2dxPrefsFile";

	// ===========================================================
	// Fields
	// ===========================================================

// TODO	private static Cocos2dMusic sCocos2dMusic;
// TODO	private static Cocos2dSound sCocos2dSound;
	private static AssetManager sAssetManager;
// TODO	private static Cocos2dAccelerometer sCocos2dAccelerometer;
	private static boolean sAccelerometerEnabled;
	private static String sPackageName;
	private static String sFileDirectory;
	private static Context sContext = null;
	private static Cocos2dHelperListener sCocos2dHelperListener;

	// ===========================================================
	// Constructors
	// ===========================================================

	public static void init(final Context pContext, final Cocos2dHelperListener pCocos2dHelperListener) {
		final ApplicationInfo applicationInfo = pContext.getApplicationInfo();
		
		Cocos2dHelper.sContext = pContext;
		Cocos2dHelper.sCocos2dHelperListener = pCocos2dHelperListener;

		Cocos2dHelper.sPackageName = applicationInfo.packageName;
		Cocos2dHelper.sFileDirectory = pContext.getFilesDir().getAbsolutePath();
		Cocos2dHelper.nativeSetApkPath(applicationInfo.sourceDir);

// TODO		Cocos2dHelper.sCocos2dxAccelerometer = new Cocos2dxAccelerometer(pContext);
// TODO		Cocos2dHelper.sCocos2dMusic = new Cocos2dxMusic(pContext);
// TODO		Cocos2dHelper.sCocos2dSound = new Cocos2dxSound(pContext);
		Cocos2dHelper.sAssetManager = pContext.getAssets();
// TODO		Cocos2dBitmap.setContext(pContext);
	}

	// ===========================================================
	// Getter & Setter
	// ===========================================================

	// ===========================================================
	// Methods for/from SuperClass/Interfaces
	// ===========================================================

	// ===========================================================
	// Methods
	// ===========================================================

	private static native void nativeSetApkPath(final String pApkPath);

	private static native void nativeSetEditTextDialogResult(final byte[] pBytes);

	public static String getCocos2dxPackageName() {
		return Cocos2dHelper.sPackageName;
	}

	public static String getCocos2dxWritablePath() {
		return Cocos2dHelper.sFileDirectory;
	}

	public static String getCurrentLanguage() {
		return Locale.getDefault().getLanguage();
	}
	
	public static String getDeviceModel(){
		return Build.MODEL;
    }

	public static AssetManager getAssetManager() {
		return Cocos2dHelper.sAssetManager;
	}

	public static void enableAccelerometer() {
		Cocos2dHelper.sAccelerometerEnabled = true;
// TODO		Cocos2dHelper.sCocos2dxAccelerometer.enable();
	}


	public static void setAccelerometerInterval(float interval) {
// TODO		Cocos2dHelper.sCocos2dAccelerometer.setInterval(interval);
	}

	public static void disableAccelerometer() {
		Cocos2dHelper.sAccelerometerEnabled = false;
// TODO		Cocos2dHelper.sCocos2dAccelerometer.disable();
	}

	public static void preloadBackgroundMusic(final String pPath) {
// TODO		Cocos2dHelper.sCocos2dMusic.preloadBackgroundMusic(pPath);
	}

	public static void playBackgroundMusic(final String pPath, final boolean isLoop) {
// TODO		Cocos2dHelper.sCocos2dMusic.playBackgroundMusic(pPath, isLoop);
	}

	public static void resumeBackgroundMusic() {
// TODO		Cocos2dHelper.sCocos2dMusic.resumeBackgroundMusic();
	}

	public static void pauseBackgroundMusic() {
// TODO		Cocos2dHelper.sCocos2dMusic.pauseBackgroundMusic();
	}

	public static void stopBackgroundMusic() {
// TODO		Cocos2dHelper.sCocos2dMusic.stopBackgroundMusic();
	}

	public static void rewindBackgroundMusic() {
// TODO		Cocos2dHelper.sCocos2dMusic.rewindBackgroundMusic();
	}

	public static boolean isBackgroundMusicPlaying() {
// TODO		return Cocos2dHelper.sCocos2dMusic.isBackgroundMusicPlaying();
		return false;
	}

	public static float getBackgroundMusicVolume() {
// TODO		return Cocos2dHelper.sCocos2dMusic.getBackgroundVolume();
		return 0.0f;
	}

	public static void setBackgroundMusicVolume(final float volume) {
// TODO		Cocos2dHelper.sCocos2dMusic.setBackgroundVolume(volume);
	}

	public static void preloadEffect(final String path) {
// TODO		Cocos2dHelper.sCocos2dSound.preloadEffect(path);
	}

	public static int playEffect(final String path, final boolean isLoop) {
// TODO		return Cocos2dHelper.sCocos2dSound.playEffect(path, isLoop);
		return 0;
	}

	public static void resumeEffect(final int soundId) {
// TODO		Cocos2dHelper.sCocos2dSound.resumeEffect(soundId);
	}

	public static void pauseEffect(final int soundId) {
// TODO		Cocos2dHelper.sCocos2dSound.pauseEffect(soundId);
	}

	public static void stopEffect(final int soundId) {
// TODO		Cocos2dHelper.sCocos2dSound.stopEffect(soundId);
	}

	public static float getEffectsVolume() {
// TODO		return Cocos2dHelper.sCocos2dSound.getEffectsVolume();
		return 0;
	}

	public static void setEffectsVolume(final float volume) {
// TODO		Cocos2dHelper.sCocos2dSound.setEffectsVolume(volume);
	}

	public static void unloadEffect(final String path) {
// TODO		Cocos2dHelper.sCocos2dSound.unloadEffect(path);
	}

	public static void pauseAllEffects() {
// TODO		Cocos2dHelper.sCocos2dSound.pauseAllEffects();
	}

	public static void resumeAllEffects() {
// TODO		Cocos2dHelper.sCocos2dSound.resumeAllEffects();
	}

	public static void stopAllEffects() {
// TODO		Cocos2dHelper.sCocos2dSound.stopAllEffects();
	}

	public static void end() {
// TODO		Cocos2dHelper.sCocos2dMusic.end();
// TODO		Cocos2dHelper.sCocos2dSound.end();
	}

	public static void onResume() {
		if (Cocos2dHelper.sAccelerometerEnabled) {
// TODO			Cocos2dHelper.sCocos2dAccelerometer.enable();
		}
	}

	public static void onPause() {
		if (Cocos2dHelper.sAccelerometerEnabled) {
// TODO			Cocos2dHelper.sCocos2dAccelerometer.disable();
		}
	}

	public static void terminateProcess() {
		android.os.Process.killProcess(android.os.Process.myPid());
	}

	private static void showDialog(final String pTitle, final String pMessage) {
		Cocos2dHelper.sCocos2dHelperListener.showDialog(pTitle, pMessage);
	}

	private static void showEditTextDialog(final String pTitle, final String pMessage, final int pInputMode, final int pInputFlag, final int pReturnType, final int pMaxLength) {
		Cocos2dHelper.sCocos2dHelperListener.showEditTextDialog(pTitle, pMessage, pInputMode, pInputFlag, pReturnType, pMaxLength);
	}

	public static void setEditTextDialogResult(final String pResult) {
		try {
			final byte[] bytesUTF8 = pResult.getBytes("UTF8");

			Cocos2dHelper.sCocos2dHelperListener.runOnGLThread(new Runnable() {
				@Override
				public void run() {
					Cocos2dHelper.nativeSetEditTextDialogResult(bytesUTF8);
				}
			});
		} catch (UnsupportedEncodingException pUnsupportedEncodingException) {
			/* Nothing. */
		}
	}

	public static int getDPI() {
		if (sContext != null)
		{
			DisplayMetrics metrics = new DisplayMetrics();
			WindowManager wm = ((Activity)sContext).getWindowManager();
			if (wm != null)
			{
				Display d = wm.getDefaultDisplay();
				if (d != null)
				{
					d.getMetrics(metrics);
					return (int)(metrics.density*160.0f);
				}
			}
		}
		return -1;
	}

	// ===========================================================
	// Functions for CCUserDefault
	// ===========================================================

	public static boolean getBoolForKey(String key, boolean defaultValue) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		return settings.getBoolean(key, defaultValue);
	}

	public static int getIntegerForKey(String key, int defaultValue) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		return settings.getInt(key, defaultValue);
	}

	public static float getFloatForKey(String key, float defaultValue) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		return settings.getFloat(key, defaultValue);
	}

	public static double getDoubleForKey(String key, double defaultValue) {
		// SharedPreferences doesn't support saving double value
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		return settings.getFloat(key, (float)defaultValue);
	}

	public static String getStringForKey(String key, String defaultValue) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		return settings.getString(key, defaultValue);
	}

	public static void setBoolForKey(String key, boolean value) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		SharedPreferences.Editor editor = settings.edit();
		editor.putBoolean(key, value);
		editor.commit();
	}

	public static void setIntegerForKey(String key, int value) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		SharedPreferences.Editor editor = settings.edit();
		editor.putInt(key, value);
		editor.commit();
	}

	public static void setFloatForKey(String key, float value) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		SharedPreferences.Editor editor = settings.edit();
		editor.putFloat(key, value);
		editor.commit();
	}

	public static void setDoubleForKey(String key, double value) {
		// SharedPreferences doesn't support recording double value
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		SharedPreferences.Editor editor = settings.edit();
		editor.putFloat(key, (float)value);
		editor.commit();
	}

	public static void setStringForKey(String key, String value) {
		SharedPreferences settings = ((Activity)sContext).getSharedPreferences(Cocos2dHelper.PREFS_NAME, 0);
		SharedPreferences.Editor editor = settings.edit();
		editor.putString(key, value);
		editor.commit();
	}

	// ===========================================================
	// Inner and Anonymous Classes
	// ===========================================================

	public static interface Cocos2dHelperListener {
		public void showDialog(final String pTitle, final String pMessage);
		public void showEditTextDialog(final String pTitle, final String pMessage, final int pInputMode, final int pInputFlag, final int pReturnType, final int pMaxLength);

		public void runOnGLThread(final Runnable pRunnable);
	}
}
