package org.cocos2d.menu_nodes;

import org.cocos2d.nodes.CCLabelAtlas;

/**
 * @addtogroup GUI
 * @{
 * @addtogroup menu
 * @{
 */

/** @brief A CCMenuItemAtlasFont
 * Helper class that creates a MenuItemLabel class with a LabelAtlas
 */
public class CCMenuItemAtlasFont extends CCMenuItemLabel {
	public CCMenuItemAtlasFont(){
	}

	/** creates a menu item from a string and atlas with a target/selector */
	public static CCMenuItemAtlasFont create(String value, String charMapFile, int itemWidth, int itemHeight, char startCharMap) {
		return CCMenuItemAtlasFont.create(value, charMapFile, itemWidth, itemHeight, startCharMap, null, null);
	}

	/** creates a menu item from a string and atlas. Use it with MenuItemToggle */
	public static CCMenuItemAtlasFont create(String value, String charMapFile, int itemWidth, int itemHeight, char startCharMap, Object target, String selector) {
		CCMenuItemAtlasFont pRet = new CCMenuItemAtlasFont();
		pRet.initWithString(value, charMapFile, itemWidth, itemHeight, startCharMap, target, selector);
		return pRet;
	}

	/** initializes a menu item from a string and atlas with a target/selector */
	public boolean initWithString(String value, String charMapFile, int itemWidth, int itemHeight, char startCharMap, Object target, String selector) {
		assert (value != null) && (value.length() != 0) : "value length must be greater than 0";
		CCLabelAtlas label = new CCLabelAtlas();
		label.initWithString(value, charMapFile, itemWidth, itemHeight, startCharMap);
		if(super.initWithLabel(label, target, selector)) {
			// do something ?
		}
		return true;
	}
}

// end of GUI group
/// @}
/// @}
