package org.cocos2d.actions.tile;

import org.cocos2d.cocoa.CCGeometry.CCPoint;
import org.cocos2d.types.ccGridSize;

public class Tile {
	CCPoint	position = new CCPoint();
	CCPoint	startPosition = new CCPoint();
	ccGridSize	delta;

    public static Tile make(CCPoint pos, CCPoint startPos, ccGridSize gs) {
        return new Tile(pos, startPos, gs);
    }

    public static Tile make() {
        return new Tile();
    }

    protected Tile(CCPoint pos, CCPoint startPos, ccGridSize gs) {
        position.setPoint(pos);
        startPosition.setPoint(startPos);
        delta = ccGridSize.ccg(gs.x, gs.y);
    }

    protected Tile() {
        // warning: all members are not initialized
    }
}

