package org.cocos2d.menu_nodes;

import org.cocos2d.nodes.CCNode;
import org.cocos2d.nodes.CCSprite;
import org.cocos2d.nodes.CCSpriteFrame;

/**
 * @addtogroup GUI
 * @{
 * @addtogroup menu
 * @{
 */

/** @brief CCMenuItemImage accepts images as items.
 * The images has 3 different states:
 * - unselected image
 * - selected image
 * - disabled image
 * 
 * For best results try that all images are of the same size
 */
public class CCMenuItemImage extends CCMenuItemSprite {

	public CCMenuItemImage(){
	}

	/** creates a menu item with a normal and selected image*/
	public static CCMenuItemImage create(String normalImage, String selectedImage) {
		return CCMenuItemImage.create(normalImage, selectedImage, null, null, null);
	}

	/** creates a menu item with a normal,selected  and disabled image*/
	public static CCMenuItemImage create(String normalImage, String selectedImage, String disabledImage) {
		CCMenuItemImage pRet = new CCMenuItemImage();
		if(! pRet.initWithNormalImage(normalImage, selectedImage, disabledImage, null, null)) {
			pRet = null;
		}
		return pRet;
	}

	/** creates a menu item with a normal and selected image with target/selector */
	public static CCMenuItemImage create(String normalImage, String selectedImage, Object target, String selector) {
		return CCMenuItemImage.create(normalImage, selectedImage, null, target, selector);
	}

	/** creates a menu item with a normal,selected  and disabled image with target/selector */
	public static CCMenuItemImage create(String normalImage, String selectedImage, String disabledImage, Object target, String selector) {
		CCMenuItemImage pRet = new CCMenuItemImage();
		if(! pRet.initWithNormalImage(normalImage, selectedImage, disabledImage, target, selector)) {
			pRet = null;
		}
		return pRet;
	}

	public boolean init() {
		return initWithNormalImage(null, null, null, null, null);
	}

	/** initializes a menu item with a normal, selected  and disabled image with target/selector */
	public boolean initWithNormalImage(String normalImage, String selectedImage, String disabledImage, Object target, String selector) {
		CCNode normalSprite = null;
		CCNode selectedSprite = null;
		CCNode disabledSprite = null;

		if(normalImage != null) {
// TODO			normalSprite = CCSprite.create(normalImage);
			normalSprite = CCSprite.sprite(normalImage);
		}

		if(selectedImage != null) {
// TODO			selectedSprite = CCSprite.create(selectedImage);
			selectedSprite = CCSprite.sprite(selectedImage);
		}

		if(disabledImage != null) {
// TODO			disabledSprite = CCSprite.create(disabledImage);
			disabledSprite = CCSprite.sprite(disabledImage);
		}
		return initWithNormalSprite(normalSprite, selectedSprite, disabledSprite, target, selector);
	}

	/** sets the sprite frame for the normal image */
	public void setNormalSpriteFrame(CCSpriteFrame frame) {
// TODO		setNormalImage(CCSprite.createWithSpriteFrame(frame));
		setNormalImage(CCSprite.sprite(frame));
	}

	/** sets the sprite frame for the selected image */
	public void setSelectedSpriteFrame(CCSpriteFrame frame) {
// TODO		setSelectedImage(CCSprite.createWithSpriteFrame(frame));
		setSelectedImage(CCSprite.sprite(frame));
	}

	/** sets the sprite frame for the disabled image */
	public void setDisabledSpriteFrame(CCSpriteFrame frame) {
// TODO		setDisabledImage(CCSprite.createWithSpriteFrame(frame));
		setDisabledImage(CCSprite.sprite(frame));
	}

	/** Creates an CCMenuItemImage.
	 */
	public static CCMenuItemImage create() {
		CCMenuItemImage pRet = new CCMenuItemImage();
		if(! pRet.init()) {
			pRet = null;
		}
		return pRet;
	}
}

// end of GUI group
/// @}
/// @}
