package org.cocos2d.actions.tile;

import org.cocos2d.types.CGPoint;
import org.cocos2d.types.CGSize;
import org.cocos2d.types.ccGridSize;

////////////////////////////////////////////////////////////

/** CCFadeOutDownTiles action.
 Fades out the tiles in downwards direction
 */
public class CCFadeOutDownTiles extends CCFadeOutUpTiles {
	public static CCFadeOutDownTiles action(CGSize gSize, float d) {
		return new CCFadeOutDownTiles(gSize, d);
	}
	
	protected CCFadeOutDownTiles(CGSize gSize, float d) {
		super(gSize, d);
	}
	
	@Override
    public float testFunc(ccGridSize pos, float time) {
        CGPoint	n = CGPoint.ccpMult(CGPoint.ccp(gridSize.width,gridSize.height), (1.0f - time));
        if ( pos.y == 0 )
            return 1.0f;
        return (float)Math.pow( n.y / pos.y, 6 );
    }

}

