package org.cocos2d.actions.grid;

import org.cocos2d.types.CCVertex3D;
import org.cocos2d.types.CGPoint;
import org.cocos2d.types.CGSize;

////////////////////////////////////////////////////////////

/** CCLiquid action */
public class CCLiquid extends CCGrid3DAction {
	int waves;
	/** amplitude */
	float amplitude;
	/** amplitude rate */
	float amplitudeRate;
	
	/** creates the action with amplitude, a grid and duration */
	public static CCLiquid action(int wav, float amp, CGSize gridSize, float d) {
		return new CCLiquid(wav, amp, gridSize, d);
	}

	/** initializes the action with amplitude, a grid and duration */
	public CCLiquid(int wav, float amp, CGSize gSize, float d) {
		super(gSize, d);
		waves = wav;
		amplitude = amp;
		amplitudeRate = 1.0f;
	}

	@Override
	public void update(float time) {
		int i, j;
		
		for( i = 1; i < gridSize.width; i++ ) {
			for( j = 1; j < gridSize.height; j++ ) {
				CCVertex3D	v = originalVertex(CGPoint.ccp(i,j));
				v.x = (float)(v.x + (Math.sin(time*Math.PI*waves*2 + v.x * .01f) * amplitude * amplitudeRate));
				v.y = (float)(v.y + (Math.sin(time*Math.PI*waves*2 + v.y * .01f) * amplitude * amplitudeRate));
				setVertex(CGPoint.ccp(i,j), v);
			}
		}
	}	

	@Override
	public CCLiquid copy() {
		CCLiquid copy = new CCLiquid(waves, amplitude, gridSize, duration);
		return copy;
	}
}
