#
# Copyright (c) 2023 supercell
#
# SPDX-License-Identifier: BSD-3-Clause
#

module Luce
  # Parses preformatted code blocks that are indented by four spaces.
  class CodeBlockSyntax < BlockSyntax
    def pattern : Regex
      Luce.indent_pattern
    end

    def can_end_block?(parser : BlockParser) : Bool
      false
    end

    def parse_child_lines(parser : BlockParser) : Array(String?)
      child_lines = [] of String?

      until parser.done?
        match = pattern.match(parser.current)
        if !match.nil?
          child_lines << match[1]
          parser.advance
        else
          # If there's a codeblock, then a newline, then a codeblock,
          # keep the code blocks together.
          next_match = !parser.next.nil? ? pattern.match(parser.next.not_nil!) : nil
          if parser.current.strip.empty? && !next_match.nil?
            child_lines << ""
            child_lines << next_match[1]
            parser.advance
            parser.advance
          else
            break
          end
        end
      end

      child_lines
    end

    def parse(parser : BlockParser) : Node
      child_lines = parse_child_lines(parser)

      # The Markdown tests expect a trailing newline
      child_lines << ""

      content = child_lines.join("\n")
      content = Luce.escape_html(content) if parser.document.encode_html?

      Element.new("pre", [Element.text("code", content)] of Node)
    end
  end
end
