require "./spec_helper"

describe "Luce Custom Extensions" do
  describe "Regex.all_matches" do
    it "finds 3 simple matches" do
      exp = Regex.new(%q{(\w+)})
      str = "Parse my string"
      matches = exp.all_matches(str)
      matches.size.should eq 3
      matches[0][0].should eq "Parse"
      matches[1][0].should eq "my"
      matches[2][0].should eq "string"
    end

    it "progressed correctly for empty matches and that it includes the empty match at the end position" do
      exp = Regex.new("a?")
      str = "babba"
      exp.all_matches(str).map { |x| x[0] }.should eq ["", "a", "", "", "a", ""]
    end

    it "works with optional start index" do
      exp = Regex.new("as{2}")
      str = "assassin"
      exp.all_matches(str).size.should eq 2
      exp.all_matches(str, 0).size.should eq 2
      exp.all_matches(str, 1).size.should eq 1
      exp.all_matches(str, 4).size.should eq 0
      exp.all_matches(str, str.size).size.should eq 0
      expect_raises(IndexError) { exp.all_matches(str, -1) }
      expect_raises(IndexError) { exp.all_matches(str, str.size + 1) }

      exp = Regex.new(".*")
      exp.all_matches(str, str.size)[0][0].should eq ""
    end

    it "'^' always matches at the beginning of the string" do
      exp = Regex.new("^ass")
      str = "assassin"
      exp.all_matches(str, 0).size.should eq 1
      exp.all_matches(str, 3).size.should eq 0
    end
  end
end
