#pragma once

//! @file Mix/Vector4.h
//! @brief 4_xNgNXCN[ht@C

namespace Mix{

	class Vector3;

	//! @class Vector4
	//! @brief 4_xNgNX
	class _MIX_DLL_API Vector4
	{
	public:
		union
		{
			struct
			{
				Float32 x;	//!< XW
				Float32 y;	//!< YW
				Float32 z;	//!< ZW
				Float32 w;	//!< WW
			};

			struct
			{
				Float32 r;	//!< R
				Float32 g;	//!< G
				Float32 b;	//!< B
				Float32 a;	//!< A
			};

			Float32 data[4];	//!< f[^
		};

	public:
		//! @brief RXgN^
		Vector4( void );
		//! @brief RXgN^
		//! @param[in] v xNg
		Vector4( const Vector4& v );
		//! @brief RXgN^
		//! @param[in] v xNg
		Vector4( const Vector3& v );
		//! @brief RXgN^
		//! @param[in] vx XW
		//! @param[in] vy YW
		//! @param[in] vz ZW
		Vector4( Float32 vx, Float32 vy, Float32 vz );
		//! @brief RXgN^
		//! @param[in] vx XW
		//! @param[in] vy YW
		//! @param[in] vz ZW
		//! @param[in] vw WW
		Vector4( Float32 vx, Float32 vy, Float32 vz, Float32 vw );

		//! @brief r
		//! @param[in] v rxNg
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const Vector4& v ) const;
		//! @brief r
		//! @param[in] v rxNg
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const Vector4& v ) const;

		//! @brief 
		//! @param[in] v l
		//! @return ꂽxNgԂ܂
		Vector4& operator = ( const Vector4& v );
		//! @brief 
		//! @param[in] v l
		//! @return ꂽxNgԂ܂
		Vector4& operator = ( const Vector3& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4& operator += ( const Vector4& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4& operator -= ( const Vector4& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4& operator *= ( const Vector4& v );
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector4& operator *= ( Float32 s );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4& operator /= ( const Vector4& v );
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector4& operator /= ( Float32 s );

		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4 operator + ( const Vector4& v ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4 operator - ( const Vector4& v ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4 operator * ( const Vector4& v ) const;
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector4 operator * ( Float32 s ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector4 operator / ( const Vector4& v ) const;
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector4 operator / ( Float32 s ) const;

		//! @brief ̕ƂĈ܂
		//! @return xNgԂ܂
		Vector4 operator +( void ) const;
		//! @brief 𔽓]܂
		//! @return 𔽓]xNgԂ܂
		Vector4 operator -( void ) const;

		//! @brief Z
		//! @param[in] s Z̒l
		//! @param[in] v Z̒l
		//! @return ZꂽxNgԂ܂
		friend const Vector4 operator * ( Float32 s, const Vector4& v )
		{
			Vector4 tmp( v );
			tmp *= s;
			return tmp;
		}

		//! @brief Z
		//! @param[in] s Z̒l
		//! @param[in] v Z̒l
		//! @return ZꂽxNgԂ܂
		friend const Vector4 operator / ( Float32 s, const Vector4& v )
		{
			Vector4 tmp( v );
			tmp /= s;
			return tmp;
		}

		//! @brief xNgݒ肵܂
		//! @param[in] vx XW
		//! @param[in] vy YW
		//! @param[in] vz ZW
		//! @param[in] vw WW
		void Set( Float32 vx, Float32 vy, Float32 vz, Float32 vw );

		//! @brief K܂
		//! @return KÕxNg̒Ԃ܂
		Float32 Normalize( void );
		//! @brief KxNg擾܂
		//! @param[out] pLength KÕxNg̒ 
		//! @return KxNg\ Mix::Vector4 NXԂ܂
		Vector4 ToNormalize( Float32* pLength = NULL ) const;

		//! @brief 0.0f`1.0f ɖOa܂
		void Saturate( void );
		//! @brief 0.0f`1.0f ɖOaxNg擾܂
		//! @return OaxNg\ Mix::Vector4 NXԂ܂
		Vector4 ToSaturate( void ) const;

		//! @brief 2擾܂
		//! @return 2Ԃ܂
		Float32 GetLengthSqr( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		Float32 GetLength( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		//! @note ߂ۂ Mix::SqrtF gpĂ܂
		Float32 GetLengthF( void ) const;

		//! @brief ̃xNg̓ςԂ܂
		//! @param[in] lv xNg1
		//! @param[in] rv xNg2
		//! @return ςԂ܂
		static Float32 Dot( const Vector4& lv, const Vector4& rv );
		//! @brief ̃xNg̊OςԂ܂
		//! @param[in] lv xNg1
		//! @param[in] rv xNg2
		//! @return OςԂ܂
		static Vector4 Cross( const Vector4& lv, const Vector4& rv );

		//! @brief ( 0.0f`1.0f )擾܂
		//! @return \ Mix::Vector4 NXԂ܂
		static Vector4 Rand( void );
		//! @brief ( 0.0f`v )擾܂
		//! @param[in] v ͈̔͂\ x::Vector4 NX
		//! @return \ Mix::Vector4 NXԂ܂
		static Vector4 Rand( const Vector4& v );
		//! @brief ( v0`v1 )擾܂
		//! @param[in] v0 ̊Jnl\ Mix::Vector4 NX
		//! @param[in] v1 ̏Il\ Mix::Vector4 NX
		//! @return \ Mix::Vector4 NXԂ܂
		static Vector4 Rand( const Vector4& v0, const Vector4& v1 );

		//! @brief ̃xNg̍ŏl擾܂
		//! @param[in] v0 xNg
		//! @param[in] v1 xNg
		//! @return xNg̍ŏl\ Mix::Vector4 NXԂ܂
		static Vector4 Min( const Vector4& v0, const Vector4& v1 );
		//! @brief ̃xNg̍ől擾܂
		//! @param[in] v0 xNg
		//! @param[in] v1 xNg
		//! @return xNg̍ől\ Mix::Vector4 NXԂ܂
		static Vector4 Max( const Vector4& v0, const Vector4& v1 );

		//! @brief `Ԃ܂
		//! @param[in] vs `ԂJnxNg\ Mix::Vector4 NX
		//! @param[in] ve `ԂIxNg\ Mix::Vector4 NX
		//! @param[in] t ԌW( 0.0f`1.0f )
		//! @return `ԂꂽxNg\ Mix::Vector4 NXԂ܂
		static Vector4 Lerp( const Vector4& vs, const Vector4& ve, Float32 t );
		//! @brief ʐ`Ԃ܂
		//! @param[in] vs ԂJnxNg\ Mix::Vector4 NX
		//! @param[in] ve ԂIxNg\ Mix::Vector4 NX
		//! @param[in] t ԌW( 0.0f`1.0f )
		//! @return ԂꂽxNg\ Mix::Vector4 Ԃ܂
		static Vector4 Slerp( const Vector4& vs, const Vector4& ve, Float32 t );

	public:
		//! @brief l( 0.0, 0.0, 0.0, 1.0 )擾܂
		//! @return l\ Mix::Vector4 NXԂ܂
		static const Vector4& Zero( void )
		{
			static const Vector4 zero( 0.0f, 0.0f, 0.0f, 1.0f );
			return zero;
		}

		//! @brief X( 1.0, 0.0, 0.0, 1.0 )擾܂
		//! @return X\ Mix::Vector4 NXԂ܂
		static const Vector4& XAxis( void )
		{
			static const Vector4 xAxis( 1.0f, 0.0f, 0.0f, 1.0f );
			return xAxis;
		}

		//! @brief Y( 0.0, 1.0, 0.0, 1.0 )擾܂
		//! @return Y\ Mix::Vector4 NXԂ܂
		static const Vector4& YAxis( void )
		{
			static const Vector4 yAxis( 0.0f, 1.0f, 0.0f, 1.0f );
			return yAxis;
		}

		//! @brief Z( 0.0, 0.0, 1.0, 1.0 )擾܂
		//! @return Z\ Mix::Vector4 NXԂ܂
		static const Vector4& ZAxis( void )
		{
			static const Vector4 zAxis( 0.0f, 0.0f, 1.0f, 1.0f );
			return zAxis;
		}
	};

}
