#pragma once

//! @file Mix/Vector3.h
//! @brief 3_xNgNXCN[ht@C

namespace Mix{

	class Vector4;

	//! @class Vector3
	//! @brief 3_xNgNX
	class _MIX_DLL_API Vector3
	{
	public:
		union
		{
			struct
			{
				Float32 x;	//!< XW
				Float32 y;	//!< YW
				Float32 z;	//!< ZW
			};

			struct
			{
				Float32 r;	//!< R
				Float32 g;	//!< G
				Float32 b;	//!< B
			};

			Float32 data[3];	//!< f[^
		};

	public:
		//! @brief RXgN^
		Vector3( void );
		//! @brief RXgN^
		//! @param[in] v xNg
		Vector3( const Vector3& v );
		//! @brief RXgN^
		//! @param[in] v xNg
		Vector3( const Vector4& v );
		//! @brief RXgN^
		//! @param[in] vx XW
		//! @param[in] vy YW
		//! @param[in] vz ZW
		Vector3( Float32 vx, Float32 vy, Float32 vz );

		//! @brief r
		//! @param[in] v rxNg
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const Vector3& v ) const;
		//! @brief r
		//! @param[in] v rxNg
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const Vector3& v ) const;

		//! @brief 
		//! @param[in] v l
		//! @return ꂽxNgԂ܂
		Vector3& operator = ( const Vector3& v );
		//! @brief 
		//! @param[in] v l
		//! @return ꂽxNgԂ܂
		Vector3& operator = ( const Vector4& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3& operator += ( const Vector3& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3& operator -= ( const Vector3& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3& operator *= ( const Vector3& v );
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector3& operator *= ( Float32 s );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3& operator /= ( const Vector3& v );
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector3& operator /= ( Float32 s );

		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3 operator + ( const Vector3& v ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3 operator - ( const Vector3& v ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3 operator * ( const Vector3& v ) const;
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector3 operator * ( Float32 s ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZꂽxNgԂ܂
		Vector3 operator / ( const Vector3& v ) const;
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZꂽxNgԂ܂
		Vector3 operator / ( Float32 s ) const;

		//! @brief ̕ƂĈ܂
		//! @return xNgԂ܂
		Vector3 operator +( void ) const;
		//! @brief 𔽓]܂
		//! @return 𔽓]xNgԂ܂
		Vector3 operator -( void ) const;

		//! @brief Z
		//! @param[in] s Z̒l
		//! @param[in] v Z̒l
		//! @return ZꂽxNgԂ܂
		friend const Vector3 operator * ( Float32 s, const Vector3& v )
		{
			Vector3 tmp( v );
			tmp *= s;
			return tmp;
		}

		//! @brief Z
		//! @param[in] s Z̒l
		//! @param[in] v Z̒l
		//! @return ZꂽxNgԂ܂
		friend const Vector3 operator / ( Float32 s, const Vector3& v )
		{
			Vector3 tmp( v );
			tmp /= s;
			return tmp;
		}

		//! @brief xNgݒ肵܂
		//! @param[in] vx XW
		//! @param[in] vy YW
		//! @param[in] vz ZW
		void Set( Float32 vx, Float32 vy, Float32 vz );

		//! @brief K܂
		//! @return KO̒
		Float32 Normalize( void );
		//! @brief KxNg擾܂
		//! @param[out] pLength KÕxNg̒ 
		//! @return KxNg\ Mix::Vector3 NXԂ܂
		Vector3 ToNormalize( Float32* pLength = NULL ) const;

		//! @brief 0.0f`1.0f ɖOa܂
		void Saturate( void );
		//! @brief 0.0f`1.0f ɖOaxNg擾܂
		//! @return OaxNg\ Mix::Vector3 NXԂ܂
		Vector3 ToSaturate( void ) const;

		//! @brief 2擾܂
		//! @return 2Ԃ܂
		Float32 GetLengthSqr( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		Float32 GetLength( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		//! @note ߂ۂ Mix::SqrtF gpĂ܂
		Float32 GetLengthF( void ) const;

		//! @brief ̃xNg̓ςԂ܂
		//! @param[in] l xNg1
		//! @param[in] r xNg2
		//! @return ςԂ܂
		static Float32 Dot( const Vector3& l, const Vector3& r );
		//! @brief ̃xNg̊OςԂ܂
		//! @param[in] l xNg1
		//! @param[in] r xNg2
		//! @return OςԂ܂
		static Vector3 Cross( const Vector3& l, const Vector3& r );

		//! @brief ( 0.0f`1.0f )擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		static Vector3 Rand( void );
		//! @brief ( 0.0f`v )擾܂
		//! @param[in] v ͈̔͂\ x::Vector3 NX
		//! @return \ Mix::Vector3 NXԂ܂
		static Vector3 Rand( const Vector3& v );
		//! @brief ( v0`v1 )擾܂
		//! @param[in] v0 ̊Jnl\ Mix::Vector3 NX
		//! @param[in] v1 ̏Il\ Mix::Vector3 NX
		//! @return \ Mix::Vector3 NXԂ܂
		static Vector3 Rand( const Vector3& v0, const Vector3& v1 );

		//! @brief ̃xNg̍ŏl擾܂
		//! @param[in] v0 xNg
		//! @param[in] v1 xNg
		//! @return xNg̍ŏl\ Mix::Vector3 NXԂ܂
		static Vector3 Min( const Vector3& v0, const Vector3& v1 );
		//! @brief ̃xNg̍ől擾܂
		//! @param[in] v0 xNg
		//! @param[in] v1 xNg
		//! @return xNg̍ől\ Mix::Vector3 NXԂ܂
		static Vector3 Max( const Vector3& v0, const Vector3& v1 );

		//! @brief `Ԃ܂
		//! @param[in] vs ԂJnxNg\ Mix::Vector3 NX
		//! @param[in] ve ԂIxNg\ Mix::Vector3 NX
		//! @param[in] t Ԓl( 0.0f`1.0f )
		//! @return ԂꂽxNg\ Mix::Vector3 NXԂ܂
		static Vector3 Lerp( const Vector3& vs, const Vector3& ve, Float32 t );
		//! @brief ʐ`Ԃ܂
		//! @param[in] vs ԂJnxNg\ Mix::Vector3 NX
		//! @param[in] ve ԂIxNg\ Mix::Vector3 NX
		//! @param[in] t ԌW( 0.0f`1.0f )
		//! @return ԂꂽxNg\ Mix::Vector3 Ԃ܂
		static Vector3 Slerp( const Vector3& vs, const Vector3& ve, Float32 t );

	public:
		//! @brief l( 0.0f, 0.0f, 0.0f )擾܂
		//! @return l\ Mix::Vector3 NXԂ܂
		static const Vector3& Zero( void )
		{
			static const Vector3 zero( 0.0f, 0.0f, 0.0f );
			return zero;
		}

		//! @brief X( 1.0f, 0.0f, 0.0f )擾܂
		//! @return X\ Mix::Vector3 NXԂ܂
		static const Vector3& XAxis( void )
		{
			static const Vector3 xAxis( 1.0f, 0.0f, 0.0f );
			return xAxis;
		}

		//! @brief Y( 0.0f, 1.0f, 0.0f )擾܂
		//! @return Y\ Mix::Vector3 NXԂ܂
		static const Vector3& YAxis( void )
		{
			static const Vector3 yAxis( 0.0f, 1.0f, 0.0f );
			return yAxis;
		}

		//! @brief Z( 0.0f, 0.0f, 1.0f )擾܂
		//! @return Z\ Mix::Vector3 NXԂ܂
		static const Vector3& ZAxis( void )
		{
			static const Vector3 zAxis( 0.0f, 0.0f, 1.0f );
			return zAxis;
		}
	};

}
