#pragma once

//! @file Mix/Sound/IController.h
//! @brief TEhRg[[C^[tF[XCN[ht@C

#include "Mix/Sound/IDevice.h"

namespace Mix{ namespace Sound{

	//! @class IController
	//! @brief TEhRg[[C^[tF[X
	class IController : public Mix::Sound::IDevice
	{
	protected:
		//! @brief fXgN^
		virtual ~IController( void ){};

	public:
		//! @brief {[擾܂
		//! @return {[Ԃ܂
		virtual Float32 GetVolume( void ) const = 0;
		//! @brief {[ݒ肵܂
		//! @param[in] volume {[( ŏ[0.0] ` ő[1.0] )
		virtual void SetVolume( Float32 volume ) = 0;

		//! @brief p|bg擾܂
		//! @return p|bgԂ܂
		virtual Float32 GetPanpot( void ) const = 0;
		//! @brief p|bgݒ肵܂
		//! @param[in] panpot p|bg( [-1.0] ` [0.0] ` E[1.0] )
		virtual void SetPanpot( Float32 panpot ) = 0;

		//! @brief ł邩ǂ擾܂
		//! @return łꍇ True Ԃ܂
		virtual Boolean IsCloneable( void ) const = 0;
		//! @brief g𕡐܂
		//! @param[out] ppController Rg[[n Mix::Sound::IController C^[tF[X̃|C^̃AhX
		virtual Boolean Clone( Mix::Sound::IController** ppController ) = 0;
	};

}}
