#pragma once

//! @file Mix/Scene/IWaterPool.h
//! @brief EH[^[v[C^[tF[XCN[ht@C

#include "Mix/Scene/IRendererObject.h"
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{

	//! @class IWaterPoolContext
	//! @brief EH[^[v[ReLXgC^[tF[X
	class IWaterPoolContext : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IWaterPoolContext( void ) {}

	public:
		//! @brief XV܂
		//! @param[in] worldMat XVɎgp郏[hs\ Mix::Matrix4x4 NX
		//! @note GetBounds Ŏ擾鋫EXVKv܂B
		virtual void Update( const Mix::Matrix4x4& worldMat ) = 0;

		//! @brief E擾܂
		//! @return E\ Mix::Geometry::AABB NXԂ܂
		virtual const Mix::Geometry::AABB& GetBounds( void ) const = 0;

		//! @brief ʒu֌WɂĖ₢킹܂
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		//! @return ʂƂ̋Ԃ܂( ʂ > 0 >= ʂ艺 )
		//! @note ̃\bh GetBounds ɂĎ擾ꂽEŊȈՔsɌĂяo܂B
		virtual Float32 Contains( const Mix::Vector3& pos ) const = 0;
		//! @brief ʒu֌WĖ₢킹܂
		//! @param[in] bounds E\ Mix::Geometry::AABB NX
		//! @return ʒu֌W\ Mix::Scene::WATER_CONTAINS_RESULT 񋓒萔Ԃ܂
		//! @note ̃\bh GetBounds ɂĎ擾ꂽEŊȈՔsɌĂяo܂B
		virtual Mix::Scene::WATER_CONTAINS_RESULT Contains( const Mix::Geometry::AABB& bounds ) const = 0;
		//! @brief ʒu֌WĖ₢킹܂
		//! @param[in] bounds E\ Mix::Geometry::Sphere NX
		//! @return ʒu֌W\ Mix::Scene::WATER_CONTAINS_RESULT 񋓒萔Ԃ܂
		//! @note ̃\bh GetBounds ɂĎ擾ꂽEŊȈՔsɌĂяo܂B
		virtual Mix::Scene::WATER_CONTAINS_RESULT Contains( const Mix::Geometry::Sphere& bounds ) const = 0;
	};

	//! @class IWaterPool
	//! @brief EH[^[v[C^[tF[X
	class IWaterPool : public Mix::Scene::IRendererObject
	{
	public:
		//! @struct VISUAL_PARAM
		//! @brief \p[^\
		struct VISUAL_PARAM
		{
			Mix::Vector4 color;	//!< F
			Float32 density;	//!< O牜ɌĂ̐̕sx
			Float32 intensity;	//!< S̓Iȕsx
			Float32 depth;		//!< ő[x
		};

	protected:
		//! @brief fXgN^
		virtual ~IWaterPool( void ) {}

	public:
		//! @brief ܌ʂ̔ΏۂƂĂ邩ǂmF܂
		//! @return ΏۂƂĂꍇ True Ԃ܂
		virtual Boolean IsRefraction( void ) const = 0;
		//! @brief ܌ʂ̔ΏۂƂ邩ǂݒ肵܂
		//! @param[in] state ΏۂƂꍇ True
		//! @note
		//! True ƂĐݒ肵ꍇAۂɋ܌ʂŝł͂ȂA<br>
		//! ܂邩ǂEgpĔ肷邱ƂӖ܂B
		virtual void SetRefraction( Boolean state ) = 0;

		//! @brief \p[^擾܂
		//! @return p[^\ Mix::Scene::IWaterPool::VISUAL_PARAM \̂Ԃ܂
		virtual const Mix::Scene::IWaterPool::VISUAL_PARAM& GetVisualParam( void ) const = 0;
		//! @brief \p[^ݒ肵܂
		//! @param[in] param p[^\ Mix::Scene::IWaterPool::VISUAL_PARAM \
		virtual void SetVisualParam( const Mix::Scene::IWaterPool::VISUAL_PARAM& param ) = 0;

		//! @brief [hs擾܂
		//! @return s\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const = 0;
		//! @brief [hsݒ肵܂
		//! @param[in] worldMat s\ Mix::Matrix4x4 NX
		virtual void SetWorldMatrix( const Mix::Matrix4x4& worldMat ) = 0;

		//! @brief XV܂
		//! @note Mix::Scene::IWaterPoolContext::Update \bhĂяo܂B
		virtual void Update( void ) const = 0;

		//! @brief E擾܂
		//! @return E\ Mix::Geometry::AABB NXԂ܂
		//! @note Mix::Scene::IWaterPoolContext::GetBounds \bhĂяo܂B
		virtual const Mix::Geometry::AABB& GetBounds( void ) const = 0;

		//! @brief tbV܂
		//! @note V[̓ɂ锪؂ɍĔzu܂B
		virtual void Refresh( void ) const = 0;

		//! @brief C[KǂmF܂
		//! @return C[Kȏꍇ True Ԃ܂
		//! @note C[KƂ́AV[̔؂͈̔͂𒴂Ă邱ƂӖ܂B
		virtual Boolean IsIllegal( void ) const = 0;
	};

}}
