#pragma once

//! @file Mix/Scene/ISkyDome.h
//! @brief XJCh[C^[tF[XCN[ht@C

#include "Mix/Scene/IRendererObject.h"

namespace Mix{ namespace Scene{

	//! @class ISkyDome
	//! @brief XJCh[C^[tF[X
	class ISkyDome : public Mix::Scene::IRendererObject
	{
	public:
		//! @enum QUALITY
		//! @brief i񋓒萔
		enum QUALITY
		{
			QL_LOW		= 0,	//!<  : h[( 10 ) i(  6 )
			QL_MIDDLE	= 1,	//!<  : h[( 20 ) i(  8 )
			QL_HIGH		= 2,	//!<  : h[( 30 ) i( 12 )
		};

		//! @enum CONSTRAINT_TYPE
		//! @brief RXgCg^Cv
		enum CONSTRAINT_TYPE
		{
			CR_XYZ	= 0,	//!< XYZŒ
			CR_XZ	= 1,	//!< XZŒ
		};

		//! @struct HEMISPHERE_SETTINGS
		//! @brief ݒ\
		struct HEMISPHERE_SETTINGS
		{
			Float32 radius;	//!< ̔a
			Float32 height;	//!< n\ւ̍
		};

		//! @struct PLANET_INFO
		//! @brief f\
		struct PLANET_INFO
		{
			Float32 innerRadius;		//!< ̔a( n\ )
			Float32 outerRadius;		//!< O̔a( C܂ )
			Mix::Vector3 coreOffset;	//!< f̒SW̃ItZbg
		};

		//! @struct BASE_SETTINGS
		//! @brief {ݒ\
		struct BASE_SETTINGS
		{
			Mix::Vector4 color;	//!< F

			Float32 texScale;	//!< eNX`̃XP[( 0.0f ȏ )
			Float32 texOpacity;	//!< eNX`̕sx( 0.0f ȏ )
		};

		//! @struct SUN_LIGHT
		//! @brief TCg\
		struct SUN_LIGHT
		{
			Mix::Vector3 pos;	//!< ̈ʒu( [hW )
			Mix::Vector3 dir;	//!< Ƃ炵Ă
			Float32 height;		//!< ̍x( COSl )
		};

		//! @struct CLOUD_LAYER_SETTINGS
		//! @brief _C[p[^\
		struct CLOUD_LAYER_SETTINGS
		{
			//! @brief ŏ̃eNX`W
			//! @note ResetCloud Ŏgp܂
			Mix::Vector2 initialTex;

			Mix::Vector2 vel;			//!< b̈ړx
			Float32 scale;				//!< XJCh[ɓ\tۂ̂tuW̃XP[( 0.0fȏ )
			Float32 opacity;			//!< sx( 0.0fȏ )
		};

		//! @struct CLOUD_GLOBAL_SETTINGS
		//! @brief _O[oݒ\
		struct CLOUD_GLOBAL_SETTINGS
		{
			Mix::Vector4 color;	//!< F

			Float32 speed;	//!< Xs[h

			//! @brief CUV~[V̉e󂯂ꍇ True
			//! @note@C ( z ) ̉e󂯂āA_̐Fω܂B<br>
			Boolean asEffect;
			//! @brief zɂ郉CeBOsꍇ True
			//! @note
			//! CUV~[Vp\łAasEffect == True ̏ꍇɋ@\܂B<br>
			//! ܂ACeBOɂ͈ȉ̃p[^e܂B<br>
			//! <br>
			//! asCornerThreshold<br>
			//! asDarknessStart<br>
			//! asDarknessEnd<br>
			Boolean asSunLighting;

			//! @brief ̉_̈Â( 0.0f`1.0f )
			//! @note
			//! l傫قǈÂAقǖ邭Ȃ܂B<br>
			//! ܂ACUV~[Vp\łAasEffect(True) ̏ꍇɋ@\܂B
			Float32 asNightness;

			//! @brief 臒l( 0.0f`1.0f )
			//! @note
			//! t𗁂тۂɌՒfꂸAʉ߂Ă铧x臒lɂȂ܂B<br>
			//! ܂ACUV~[Vp\łAasEffect(True) asLighting(True) ̏ꍇɋ@\܂B
			Float32 asCornerThreshold;
			//! @brief ՒfĂ镔̈Â̊Jnl( 0.0f`1.0f )
			//! @note
			//! Ւf镔́Az^ɂقǖ邭Aɋ߂ȂقǈÂȂ܂B( asDarknessStart`asDarknessEnd )<br>
			//! ܂ACUV~[Vp\łAasEffect(True) asLighting(True) ̏ꍇɋ@\܂B
			Float32 asDarknessStart;
			//! @brief ՒfĂ镔̈Â̏Il( asDarknessStart`1.0f )
			//! @note
			//! ̎Ւf̓ɂĂ asDarknessStart ̐ǂłB<br>
			//! ܂ACUV~[Vp\łAasEffect(True) asLighting(True) ̏ꍇɋ@\܂B
			Float32 asDarknessEnd;
		};

		//! @struct PANORAMA_SETTINGS
		//! @brief iݒ\
		struct PANORAMA_SETTINGS
		{
			Mix::Vector4 color;		//!< F

			Mix::Vector2 scale;		//!< XP[
			Float32 offsetY;		//!< ỸItZbg
			Float32 dist;			//!< ( tHÔɉe܂ )

			//! @brief eNX`̉ւ̃s[g
			//! @note
			//! ̒l̓pm}̃NIeBɈˑ܂B
			//! <ul>
			//!   <li>QL_LOW</li> 0 1 2 3 6<br>
			//!   <li>QL_MIDDLE</li> 0 1 2 4 8<br>
			//!   <li>QL_HIGH</li> 0 1 2 3 4 6 12<br>
			//! </ul>
			//!  0 ̓s[gȂƂӖ܂
			UInt32 texRepeatNum;
		};

	protected:
		//! @brief fXgN^
		virtual ~ISkyDome( void ) {}

	public:
		//! @name S
		//! @{

		//! @brief Lǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetEnabled( Boolean state ) = 0; 

		//! @brief S^Cv擾܂
		//! @return ^Cv\ Mix::Scene::ISkyDome::CONSTRAINT_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::ISkyDome::CONSTRAINT_TYPE GetConstraintType( void ) const = 0;
		//! @brief S^Cvݒ肵܂
		//! @param[in] type ^Cv\ Mix::Scene::ISkyDome::CONSTRAINT_TYPE 񋓒萔
		virtual void SetConstraintType( Mix::Scene::ISkyDome::CONSTRAINT_TYPE type ) = 0;

		//! @brief ̕i擾܂
		//! @return i\ Mix::Scene::ISkyDome::QUALITY 񋓒萔Ԃ܂
		virtual Mix::Scene::ISkyDome::QUALITY GetHemisphereQuality( void ) const = 0;
		//! @brief ̐ݒ擾܂
		//! @return ݒ\ Mix::Scene::ISkyDome::HEMISPHERE_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ISkyDome::HEMISPHERE_SETTINGS& GetHemisphereSettings( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::ISkyDome::HEMISPHERE_SETTINGS \
		virtual void SetHemisphereSettings( const Mix::Scene::ISkyDome::HEMISPHERE_SETTINGS& settings ) = 0;

		//! @brief f̏擾܂
		//! @return \ Mix::Scene::ISkyDome::PLANET_INFO \̂Ԃ܂
		//! @note f͔̏̐ݒɂXV܂B
		virtual const Mix::Scene::ISkyDome::PLANET_INFO& GetPlanetInfo( void ) const = 0;

		//! @}

		//! @name z
		//! @{

		//! @brief z̈ʒu擾܂
		//! @return ʒu\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetSunPosition( void ) const = 0;
		//! @brief z̈ʒuݒ肵܂
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		//! @note
		//! Őݒ肳ʒu͌_( 0.0f, 0.0f, 0.0f )𒆐SƂʒuł͂ȂA<br>
		//! f̒S( PLANET_INFO::coreOffset )_ƂΈʒuɂȂ܂B
		virtual void SetSunPosition( const Mix::Vector3& pos ) = 0;

		//! @brief zɂ郉CeBO擾܂
		//! @return CeBO\ Mix::Scene::ISkyDome::SUN_LIGHT \̂Ԃ܂
		virtual const Mix::Scene::ISkyDome::SUN_LIGHT& GetSunLight( void ) const = 0;

		//! @}

		//! @name x[X
		//! @{

		//! @brief x[X̐ݒ擾܂
		//! @return ݒ\ Mix::Scene::ISkyDome::BASE_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ISkyDome::BASE_SETTINGS& GetBaseSettings( void ) const = 0;
		//! @brief x[Xݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::ISkyDome::BASE_SETTINGS \
		virtual void SetBaseSettings( const Mix::Scene::ISkyDome::BASE_SETTINGS& settings ) = 0;
		//! @brief x[X̃eNX`擾܂
		//! @param[out] ppTexture 擾eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾ɐꍇ́AeNX`̎QƃJE^ +1 ܂
		virtual Boolean GetBaseTexture( Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief x[X̃eNX`ݒ肵܂
		//! @param[in] pTexture ݒ肷eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @note ݒ肳ꂽeNX`́AQƃJE^ +1 ܂
		virtual void SetBaseTexture( Mix::Graphics::ITexture* pTexture ) = 0;

		//! @}

		//! @name NEh ( _ )
		//! @{

		//! @brief _LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsCloudEnabled( void ) const = 0;
		//! @brief _Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetCloudEnabled( Boolean state ) = 0;
		//! @brief _̃C[擾܂
		//! @return C[̐Ԃ܂
		virtual UInt32 GetCloudLayerNum( void ) const = 0;
		//! @brief _̃C[eNX`擾܂
		//! @param[in] layerIndex C[̃CfbNX( 0`1 )
		//! @param[out] ppTex 擾eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetCloudLayerTexture( UInt32 layerIndex, Mix::Graphics::ITexture** ppTex ) = 0;
		//! @brief _̃C[eNX`ݒ肵܂
		//! @param[in] layerIndex C[̃CfbNX( 0`1 )
		//! @param[in] pTex ݒ肷eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^( NULL w\ )
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetCloudLayerTexture( UInt32 layerIndex, Mix::Graphics::ITexture* pTex ) = 0;
		//! @brief _̃C[̐ݒ擾܂
		//! @param[in] layerIndex C[̃CfbNX( 0`1 )
		//! @return ݒ\ Mix::Scene::ISkyDome::CLOUD_LAYER_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ISkyDome::CLOUD_LAYER_SETTINGS& GetCloudLayerSettings( UInt32 layerIndex ) const = 0;
		//! @brief _̃C[ݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::ISkyDome::CLOUD_LAYER_SETTINGS \̂̔z
		//! @param[in] num ݒ̐( num <= 2 )
		//! @return ۂɐݒ肵p[^̐Ԃ܂
		virtual UInt32 SetCloudLayerSettings( const Mix::Scene::ISkyDome::CLOUD_LAYER_SETTINGS* settings, UInt32 num ) = 0;
		//! @brief _̃C[ݒbN܂
		//! @param[out] settings bNp[^\ Mix::Scene::ISkyDome::CLOUD_LAYER_SETTINGS \̂̃|C^̃AhX
		//! @param[in] num bNݒ̐
		//! @return ۂɃbNݒ̐Ԃ܂
		//! @note ̃\bh͐ݒz擾ƓɃC[( num )ݒ肵܂
		virtual UInt32 LockCloudLayerSettings( Mix::Scene::ISkyDome::CLOUD_LAYER_SETTINGS** settings, UInt32 num ) = 0;
		//! @brief _̃O[oݒ擾܂
		//! @return _̐ݒ\ Mix::Scene::ISkyDome::CLOUD_GLOBAL_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ISkyDome::CLOUD_GLOBAL_SETTINGS& GetCloudGlobalSettings( void ) const = 0;
		//! @brief _̃O[oݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ISkyDome::CLOUD_GLOBAL_SETTINGS \
		virtual void SetCloudGlobalSettings( const Mix::Scene::ISkyDome::CLOUD_GLOBAL_SETTINGS& settings ) = 0;
		//! @brief _Zbg܂
		//! @note Mix::Scene::ISkyDome::CLOUD_LAYER_SETTINGS \̂ initialTex ̒l_̃eNX`Wɔf܂B
		virtual void ResetCloud( void ) = 0;

		//! @}

		//! @name pm} ( i )
		//! @{

		//! @brief i݂Ă邩ǂmF܂
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ExistsPanorama( void ) const = 0;
		//! @brief i̕i擾܂
		//! @return i\ Mix::Scene::ISkyDome::QUALITY 񋓒萔Ԃ܂
		virtual Mix::Scene::ISkyDome::QUALITY GetPanoramaQuality( void ) const = 0;
		//! @brief iLǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsPanoramaEnabled( void ) const = 0;
		//! @brief iLɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetPanoramaEnabled( Boolean state ) = 0;
		//! @brief i̐ݒ擾܂
		//! @return p[^\ Mix::Scene::ISkyDome::PANORAMA_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ISkyDome::PANORAMA_SETTINGS& GetPanoramaSettings( void ) const = 0;
		//! @brief iݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::ISkyDome::PANORAMA_SETTINGS \
		virtual void SetPanoramaSettings( const Mix::Scene::ISkyDome::PANORAMA_SETTINGS& settings ) = 0;
		//! @brief ĩeNX`擾܂
		//! @param[out] ppTex eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetPanoramaTexture( Mix::Graphics::ITexture** ppTex ) = 0;
		//! @brief ĩeNX`ݒ肵܂
		//! @param[in] pTex eNX`\ Mix::Graphics::ITexture C^[tF[X
		virtual void SetPanoramaTexture( Mix::Graphics::ITexture* pTex ) = 0;
		//! @brief ݐݒ肳Ă鉓ĩp[^ɊÂāAeNX`̃AXyNg擾܂
		//! @return AXyNg\ Mix::Vector2 NXԂ܂
		virtual Mix::Vector2 GetPanoramaTextureAspectRatio( void ) const = 0;

		//! @}
	};

}}
