#pragma once

//! @file Mix/Scene/IRendererObject.h
//! @brief _[IuWFNgC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IRendererObject
	//! @brief _[IuWFNgC^[tF[XCN[ht@C
	class IRendererObject : public Mix::Reference
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			UNDEFINED			= 0,	//!< `ĂȂ_[IuWFNg
			UNIVERSAL_CAMERA	= 1,	//!< jo[TJ
			VIEW_CAMERA			= 2,	//!< r[J
			HEMISPHERE_LIGHT	= 3,	//!< w~XtBACg
			DIRECTIONAL_LIGHT	= 4,	//!< fBNViCg
			SPOT_LIGHT			= 5,	//!< X|bgCg
			POINT_LIGHT			= 6,	//!< |CgCg
			SKY_DOME			= 7,	//!< XJCh[
			ATMOSPHERE_SCATTER	= 8,	//!< CXLb^[
			LIGHT_SHAFTS_CASTER	= 9,	//!< CgVtgLX^[
			ACTOR_NODE			= 10,	//!< AN^[m[h
			ACTOR_MODEL			= 11,	//!< AN^[f
			TERRAIN_MODEL		= 12,	//!< eCf
			LEAVING_PARTICLE	= 13,	//!< [rOp[eBN
			SCATTER_PARTICLE	= 14,	//!< XLb^[p[eBN
			PLANTER				= 15,	//!< v^[
			WATER_POOL			= 16,	//!< EH[^[v[
			DYNAMICS_WORLD		= 17,	//!< _Ci~NX[h
			FLOOR				= 18,	//!< tA
			GHOST				= 19,	//!< S[Xg
		};

	protected:
		//! @brief fXgN^
		virtual ~IRendererObject( void ) {}

	public:
		//! @brief ނ擾܂
		//! @return ރ^Cv\ Mix::Scene::IRendererObject::TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const = 0;
		//! @brief _OĂ邩ǂmF܂B
		//! @return _OĂꍇ True Ԃ܂B
		virtual Boolean IsRendering( void ) const = 0;
	};

}}
