#pragma once

//! @file Mix/Scene/IParticleSystem.h
//! @brief p[eBNVXeC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IParticleSystem
	//! @brief p[eBNVXe^C^[tF[X
	class IParticleSystem : public Mix::Reference
	{
	public:
		//! @enum BASE_FLAGS
		//! @brief x[XtO񋓒萔
		enum BASE_FLAGS
		{
			//! @brief ɃJ̕܂
			BILLBOARD	= 0x00000001,

			//! @brief ̉]Aړ̉e󂯂Ȃ
			//! @note ̃tO̓[rOp[eBN̂ݗLłB
			SIMULATION_WORLD_SPACE	= 0x00000002,
		};

		//! @enum BEHAVIOR_FLAGS
		//! @brief U镑tO񋓒萔
		//! @note [rOp[eBN̂ݗLłB
		enum BEHAVIOR_FLAGS
		{
			//! @brief EɓĂȂꍇ( Mix::Scene::IParticle::IsVisible() == False )͍XVsȂ
			INVISIBLE_SLEEP	=	0x00000001,

			//! @brief ꍇ( CONFIG::farMinDist ` CONFIG::farMaxDist )͎w肳ꂽl( CONFIG::maxSkipFrames )t[XLbv
			//! @note XLbvt[ CONFIG::farMaxDist ȏōőɂȂ܂B
			FAR_SKIP_FRAMES	=	0x00000002,
		};

		//! @struct CONFIG
		//! @brief ݒ\
		struct CONFIG
		{
			//! @brief x[XtO( Mix::Scene::IParticleSystem::BASE_FLAGS 񋓒萔̑gݍ킹 )
			//! @note ̃tȎgݍ킹͓rŕύX邱Ƃ͂ł܂B
			UInt32 baseFlags;

			//! @brief U镑tO( Mix::Scene::IParticleSystem::BEHAVIOR_FLAGS 񋓒萔̑gݍ킹 )
			//! @note [rOp[eBN̂ݗLłB
			UInt32 behaviorFlags;

			//! @brief Ɣfŏ( farMinDist > farMaxDist )
			//! @note ̒l Mix::Scene::IParticle::IsFar Mix::Scene::IParticle::GetFarRatio ŕԂlɂgp܂B
			Float32 farMinDist;
			//! @brief Ɣfő勗( farMinDist < farMaxDist )
			//! @note ̒l Mix::Scene::IParticle::IsFar Mix::Scene::IParticle::GetFarRatio ŕԂlɂgp܂B
			Float32 farMaxDist;

			//! @brief XLbvőt[
			UInt32 maxSkipFrames;
		};

	protected:
		//! @brief fXgN^
		virtual ~IParticleSystem( void ){}

	public:
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::IParticleSystem::CONFIG \̂Ԃ܂
		virtual const Mix::Scene::IParticleSystem::CONFIG& GetConfig( void ) const = 0;

		//! @brief WFl[^[擾܂
		//! @param[out] ppGenerator 擾WFl[^[n Mix::Scene::IParticleGenerator C^[tF[X̃|C^̃AhX
		//! @note
		//! ̃\bh̓p[eBN( Mix::Scene::IParticle )̓Ăяo邽߁AǑĂяo͍sȂłB<br>
		//! ܂WFl[^[͊{Iɏ풓邩ƂĂB
		virtual void Internal_GetGenerator( Mix::Scene::IParticleGenerator** ppGenerator ) = 0;
		//! @brief vZbT[쐬܂
		//! @param[out] ppProcessor 쐬vZbT[n Mix::Scene::IParticleProcessor C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ̃\bh̓p[eBN( Mix::Scene::IParticle )̓Ăяo邽߁AǑĂяo͍sȂłB<br>
		//! ܂vZbT[͂̃\bhĂяo邲ƂɐV쐬ĂB
		virtual Boolean Internal_CreateProcessor( Mix::Scene::IParticleProcessor** ppProcessor ) = 0;

		//! @brief Ԋu(bP)擾܂
		//! @return ԊuԂ܂
		//! @note ̃\bh̓p[eBN( Mix::Scene::IParticle )̓Ăяo邽߁AǑĂяo͍sȂłB
		virtual Float32 Internal_GetGenerateInterval( void ) const = 0;
		//! @brief 鐔擾܂
		//! @return 鐔Ԃ܂
		//! @note ̃\bh̓p[eBN( Mix::Scene::IParticle )̓Ăяo邽߁AǑĂяo͍sȂłB
		virtual UInt32 Internal_GetGenerateCount( void ) const = 0;
	};

}}
