#pragma once

//! @file Mix/Scene/IMotionMixer.h
//! @brief [V~LT[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IMotionMixer
	//! @brief [V~LT[C^[tF[X
	class IMotionMixer : public Mix::Reference
	{
	public:
		//! @enum FLAGS
		//! @brief tO񋓒萔
		enum FLAGS
		{
			ROOT_TRANSFORM	= 0x00000001,	//!< [ggXtH[s
			BODY_TRANSFORM	= 0x00000002,	//!< {fBgXtH[s
			FRAME_STEP		= 0x00000004,	//!< t[i߂

			BOTH_TRANSFORM	= ( ROOT_TRANSFORM | BODY_TRANSFORM ), //!< [gA{fB̃gXtH[s
			ALL_FLAGS		= ( ROOT_TRANSFORM | BODY_TRANSFORM | FRAME_STEP ), //!< S
		};

	protected:
		//! @brief fXgN^
		virtual ~IMotionMixer( void ){}

	public:
		//! @brief Rg[[̐擾܂
		//! @return Rg[[̐Ԃ܂
		virtual UInt32 GetControllerCount( void ) const = 0;
		//! @brief Rg[[擾܂
		//! @param[in] index Rg[[̃CfbNX
		//! @param[out] ppController 擾Rg[[n Mix::Scene::IMotionController C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetControllerByIndex( UInt32 index, Mix::Scene::IMotionController** ppController ) = 0;
		//! @brief Rg[[擾܂
		//! @param[in] pName Rg[[̖O
		//! @param[out] ppController 擾Rg[[n Mix::Scene::IMotionController C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetControllerByName( const wchar_t* pName, Mix::Scene::IMotionController** ppController ) = 0;

		//! @brief SẴ[V~܂
		virtual void ForceStopAll( void ) = 0;

		//! @brief Xs[h擾܂
		//! @return Xs[hԂ܂
		virtual Float32 GetSpeed( void ) const = 0;
		//! @brief Xs[hݒ肵܂
		//! @param[in] speed Xs[h( 0.0f`̖ )
		//! @note Őݒ肳Xs[h͌ݍĐ̃[VׂĂɓKp܂
		virtual void SetSpeed( Float32 speed ) = 0;

		//! @brief tO擾܂
		//! @return Mix::Scene::IMotionMixer::FLAGS 񋓒萔̑gݍ킹Ԃ܂B
		virtual UInt32 GetFlags( void ) const = 0;
		//! @brief tOݒ肵܂
		//! @param[in] flags Mix::Scene::IMotionMixer::FLAGS 񋓒萔̑gݍ킹
		virtual void SetFlags( UInt32 flags ) = 0;

		//! @brief XVtO擾܂
		//! @return Mix::Scene::IMotionMixer::FLAGS 񋓒萔̑gݍ킹Ԃ܂B
		virtual UInt32 GetUpdateFlags( void ) const = 0;

		//! @brief ]x擾܂
		//! @return ]x\ Mix::Vector3 NXԂ܂
		virtual const Mix::Quaternion& GetAngularVelocity( void ) const = 0;
		//! @brief ړx擾܂
		//! @return ړx\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLinearVelocity( void ) const = 0;
	};

}}
