#pragma once

//! @file Mix/Scene/IMaterial.h
//! @brief }eAC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IMaterial
	//! @brief }eAC^[tF[X
	class IMaterial : public Mix::Reference
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			DEFAULT	= 0,	//!< ftHg( Mix::Scene::IDefaultMaterial )
		};

		//! @enum TRANSFORM_TYPE
		//! @brief gXtH[^Cv񋓒萔
		enum TRANSFORM_TYPE
		{
			TR_SIMPLE	= 0,	//!< fɐݒ肳Ă郏[hsŃgXtH[
			TR_SKINNING	= 1,	//!< {[̃[hsŃgXtH[

			TR_MAX		= 2,	//!< gXtH[^Cv̍ő吔
		};

		//! @enum TRANSPARENCY_METHOD
		//! @brief \bh񋓒萔
		enum TRANSPARENCY_METHOD
		{
			TM_LUMP			= 0,	//!< ꊇ`
			TM_INDIVIDUAL	= 1,	//!< |SPʕ`
		};

	protected:
		//! @brief fXgN^
		virtual ~IMaterial( void ){}

	public:
		//! @brief ނ擾܂
		//! @return Mix::Scene::IMaterial::TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IMaterial::TYPE GetType( void ) const = 0;

		//! @brief w肵^CṽgXtH[sł邩ǂmF܂
		//! @return słꍇ True Ԃ܂
		virtual Boolean IsTransformable( Mix::Scene::IMaterial::TRANSFORM_TYPE type ) const = 0;

		//! @brief P_̃TCY擾܂
		//! @return TCYԂ܂
		virtual UInt32 GetVertexStride( Mix::Scene::IMaterial::TRANSFORM_TYPE type ) const = 0;
		//! @brief _̓̓VOl`擾܂
		//! @return Mix::Graphics::IVertexLayout::GetElementSemanticFlags Ŏ擾łlԂ܂
		virtual UInt32 GetVertexInputSigunature( Mix::Scene::IMaterial::TRANSFORM_TYPE type ) const = 0;

		//! @brief XV( Update )KvǂmF܂
		//! @return Kvȏꍇ True Ԃ܂
		virtual Boolean NeedsUpdate( void ) const = 0;

		//! @brief e𗎂ƂǂmF܂
		//! @return e𗎂Ƃꍇ True Ԃ܂
		//! @note ̃\bh True Ԃꍇ RenderShadow s܂B
		virtual Boolean IsShadowing( void ) const = 0;
		//! @brief CeBO邩ǂmF܂
		//! @return CeBOꍇ True Ԃ܂
		//! @note ̃\bh True Ԃꍇ |CgCgAX|bgCg̎W܂B
		virtual Boolean IsLighting( void ) const = 0;
		//! @brief ܂邩ǂmF܂
		//! @return ܂ꍇ True Ԃ܂
		//! @note ̃\bh True Ԃꍇ RenderMask RenderColor s܂B
		virtual Boolean IsRefractive( void ) const = 0;
		//! @brief sǂmF܂
		//! @return słꍇ True Ԃ܂
		//! @note ̃\bh True Ԃꍇ Ƃď܂B
		virtual Boolean IsTransparency( void ) const = 0;
		//! @brief s\bh擾܂
		//! @return s\bh\ Mix::Scene::IDefaultMaterial::TRANSPARENCY_METHOD 񋓒萔Ԃ܂
		virtual Mix::Scene::IMaterial::TRANSPARENCY_METHOD GetTransparencyMethod( void ) const = 0;

		//! @brief XVۂ̌Ăяo܂
		//! @param[in] dt f^^C
		virtual void Update( Float32 dt ) = 0;

		//! @brief e̕`ݒ܂
		//! @param[in] pDevice OtbNXfoCX\ Mix::Graphics::IDevice C^[tF[X̃|C^
		//! @param[in] trType gXtH[^Cv\ Mix::Scene::IMaterial::TRANSFORM_TYPE 񋓒萔
		virtual void RenderShadow( Mix::Graphics::IDevice* pDevice, Mix::Scene::IMaterial::TRANSFORM_TYPE trType ) = 0;
		//! @brief }XN̕`ݒ܂
		//! @param[in] pDevice OtbNXfoCX\ Mix::Graphics::IDevice C^[tF[X̃|C^
		//! @param[in] trType gXtH[^Cv\ Mix::Scene::IMaterial::TRANSFORM_TYPE 񋓒萔
		virtual void RenderMask( Mix::Graphics::IDevice* pDevice, Mix::Scene::IMaterial::TRANSFORM_TYPE trType ) = 0;
		//! @brief J[̕`ݒ܂
		//! @param[in] pDevice OtbNXfoCX\ Mix::Graphics::IDevice C^[tF[X̃|C^
		//! @param[in] trType gXtH[^Cv\ Mix::Scene::IMaterial::TRANSFORM_TYPE 񋓒萔
		virtual void RenderColor( Mix::Graphics::IDevice* pDevice, Mix::Scene::IMaterial::TRANSFORM_TYPE trType ) = 0;

		//! @brief 萔̕ύXJn܂
		//! @return ύX̊Jnꍇ True Ԃ܂
		//! @note
		//! ̃p[^ύXۂɁABeginConstant EndConstant Ŋ邱ƂŁA<br>
		//! VF[_[萔( Mix::Graphics::IShaderConstant )̃bN炵AptH[}Xコ邱Ƃł܂B<br>
		//! ܂̏́AVF[_[fSATɑ΂ėLłB
		virtual Boolean BeginConstant( void ) = 0;
		//! @brief 萔̕ύXI܂
		//! @return ύX̏Iꍇ True Ԃ܂
		virtual Boolean EndConstant( void ) = 0;

		//! @brief g̃N[쐬܂
		//! @param[out] ppMaterial g̃N[n Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean Clone( Mix::Scene::IMaterial** ppMaterial ) = 0;
	};

}}
