#pragma once

//! @file Mix/Scene/IManager.h
//! @brief V[}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"
#include "Mix/Scene/ISkyDome.h"
#include "Mix/Scene/IFlowerPackage.h"
#include "Mix/Scene/IPlanter.h"
#include "Mix/Scene/IDefaultParticleSystem.h"

namespace Mix{ namespace Scene{

	//! @class IManager
	//! @brief V[}l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ) {}

	public:
		//! @name S
		//! @{

		//! @brief GtFNgpbP[W쐬܂
		//! @param[in] pDirPath fBNgpX
		//! @param[in] pName O( VF[_[f̔ԍAgq͊܂܂Ȃ )
		//! @param[out] ppEffectPackage 쐬GtFNgpbP[Wn Mix::Scene::IEffectPackage C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateEffectPackage(	const wchar_t* pDirPath, const wchar_t* pName,
												Mix::Scene::IEffectPackage** ppEffectPackage ) = 0;

		//! @brief _[쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] config _[̐ݒ\ Mix::Scene::RENDERER_CONFIG \
		//! @param[in] ppRenderer 쐬_[n Mix::Scene::IRenderer C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateRenderer( Mix::Scene::IEffectPackage* pEffectPackage,
										const Mix::Scene::RENDERER_CONFIG& config,
										Mix::Scene::IRenderer** ppRenderer,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name J
		//! @{

		//! @brief jo[TJ쐬܂
		//! @param[in] config ݒ\ Mix::Scene::CAMERA_CONFIG \
		//! @param[out] ppCamera 쐬jo[TJn Mix::Scene::IUniversalCamera C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateUniversalCamera( const Mix::Scene::CAMERA_CONFIG& config, Mix::Scene::IUniversalCamera** ppCamera, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief r[J쐬܂
		//! @param[in] config ݒ\ Mix::Scene::CAMERA_CONFIG \
		//! @param[out] ppCamera 쐬r[Jn Mix::Scene::IViewCamera C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateViewCamera( const Mix::Scene::CAMERA_CONFIG& config, Mix::Scene::IViewCamera** ppCamera, const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name Cg
		//! @{

		//! @brief Cg쐬܂
		//! @param[out] ppLight 擾Cgn Mix::Scene::IHemisphereLight C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateHemisphereLight( Mix::Scene::IHemisphereLight** ppLight, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief fBNViCg쐬܂
		//! @param[out] ppLight 擾fBNViCgn Mix::Scene::IDirectionalLight C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateDirectionalLight( Mix::Scene::IDirectionalLight** ppLight, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief X|bgCg쐬܂
		//! @param[in] ppLight 쐬X|bgCgn Mix::Scene::ISpotLight C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreatePointLight( Mix::Scene::IPointLight** ppLight, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief |CgCg쐬܂
		//! @param[in] ppLight 쐬|CgCgn Mix::Scene::IPointLight C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateSpotLight( Mix::Scene::ISpotLight** ppLight, const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name XJCh[
		//! @{

		//! @brief XJCh[쐬܂
		//! @param[in] radius ̔a
		//! @param[in] height n\̍
		//! @param[in] heQuality ̃NHeB\ Mix::Scene::ISkyDome::QUALITY 񋓒萔
		//! @param[out] ppSkyDome 쐬XJCh[n Mix::Scene::ISkyDome C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateSkyDome(	Float32 radius, Float32 height,
										Mix::Scene::ISkyDome::QUALITY heQuality,
										Mix::Scene::ISkyDome** ppSkyDome,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief XJCh[쐬܂
		//! @param[in] radius ̔a
		//! @param[in] height n\̍
		//! @param[in] heQuality ̃NHeB\ Mix::Scene::ISkyDome::QUALITY 񋓒萔
		//! @param[in] paQuality ĩNHeB\ Mix::Scene::ISkyDome::QUALITY 񋓒萔
		//! @param[out] ppSkyDome 쐬XJCh[n Mix::Scene::ISkyDome C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateSkyDome(	Float32 radius, Float32 height,
										Mix::Scene::ISkyDome::QUALITY heQuality,
										Mix::Scene::ISkyDome::QUALITY paQuality,
										Mix::Scene::ISkyDome** ppSkyDome,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name p[eBN
		//! @{

		//! @brief ftHgp[eBNVXe쐬܂
		//! @param[in] bSimWorldSpace ̉]Aړ̉e󂯂Ȃꍇ True
		//! @param[in] planeType v[̎ނ\ Mix::Scene::IDefaultParticleSystem::PLANE_TYPE 񋓒萔
		//! @param[out] ppSystem 쐬p[eBNVXen Mix::Scene::IDefaultParticleSystem C^[tF[X̃|C^
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateDefaultParticleSystem( Boolean bSimWorldSpace, Mix::Scene::IDefaultParticleSystem::PLANE_TYPE planeType, Mix::Scene::IDefaultParticleSystem** ppSystem, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief r{[hp[eBNVXe쐬܂
		//! @param[in] bSimWorldSpace ̉]Aړ̉e󂯂Ȃꍇ True
		//! @param[out] ppSystem 쐬p[eBNVXen Mix::Scene::IBillboardParticleSystem C^[tF[X̃|C^
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateBillboardParticleSystem( Boolean bSimWorldSpace, Mix::Scene::IBillboardParticleSystem** ppSystem, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief [rOp[eBN쐬܂
		//! @param[in] pMaterial [rOp[eBNŎgp}eA\ Mix::Scene::IMaterial* pMaterial C^[tF[X̃|C^
		//! @param[in] pSystem p[eBNVXe\ Mix::Scene::IParticleSystem C^[tF[X̃|C^
		//! @param[out] ppParticle 쐬[rOp[eBNn Mix::Scene::ILeavingParticle C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateLeavingParticle( Mix::Scene::IMaterial* pMaterial, Mix::Scene::IParticleSystem* pSystem, Mix::Scene::ILeavingParticle** ppParticle, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief XLb^[p[eBN쐬܂
		//! @param[in] pMaterial XLb^[p[eBNŎgp}eA\ Mix::Scene::IMaterial* pMaterial C^[tF[X̃|C^
		//! @param[in] pSystem p[eBNVXe\ Mix::Scene::IParticleSystem C^[tF[X̃|C^
		//! @param[out] ppParticle 쐬XLb^[p[eBNn Mix::Scene::IScatterParticle C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateScatterParticle( Mix::Scene::IMaterial* pMaterial, Mix::Scene::IParticleSystem* pSystem, Mix::Scene::IScatterParticle** ppParticle, const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name v^[
		//! @{

		//! @brief t[pbP[W쐬܂
		//! @param[in] pMaterial }eA
		//! @param[in] numModel f̐
		//! @param[in] models f\ Mix::Scene::IFlowerPackage::MODEL \̂̔z
		//! @param[out] ppFlowerPackage 쐬t[pbP[Wn Mix::Scene::IFlowerPackage C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateFlowerPackage(	Mix::Scene::IMaterial* pMaterial,
												UInt32 numModel, const Mix::Scene::IFlowerPackage::MODEL* models,
												Mix::Scene::IFlowerPackage** ppFlowerPackage,
												const wchar_t* pDebugName = NULL ) = 0;

		//! @brief v^[쐬܂
		//! @param[in] pFlowerPackage t[pbP[W\ Mix::Scene::IFlowerPackage C^[tF[X̃|C^
		//! @param[out] ppPlanter ǉv^[n Mix::Scene::IPlanter C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreatePlanter(	Mix::Scene::IFlowerPackage* pFlowerPackage,
										Mix::Scene::IPlanter** ppPlanter,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief v^[쐬܂
		//! @param[in] pFlowerPackage t[pbP[W\ Mix::Scene::IFlowerPackage C^[tF[X̃|C^
		//! @param[in] numUnit jbg
		//! @param[in] units jbg\ Mix::Scene::IPlanter::UNIT \̂̔z
		//! @param[in] worldMat [hs
		//! @param[out] ppPlanter ǉv^[n Mix::Scene::IPlanter C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreatePlanter(	Mix::Scene::IFlowerPackage* pFlowerPackage,
										UInt32 numUnit, const Mix::Scene::IPlanter::UNIT* units,
										const Mix::Matrix4x4& worldMat,
										Mix::Scene::IPlanter** ppPlanter,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name AN^[f
		//! @{

		//! @brief AN^[ft@C쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppModel 쐬AN^[fn Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateActorModelFromFile( Mix::Scene::IEffectPackage* pEffectPackage, const wchar_t* pFilePath, Mix::Scene::IActorModel** ppModel ) = 0;
		//! @brief AN^[ft@C쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pReader [_[\ Mix::IO::IReader C^[tF[X̃|C^
		//! @param[out] ppModel 쐬AN^[fn Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateActorModelFromReader( Mix::Scene::IEffectPackage* pEffectPackage, Mix::IO::IReader* pReader, Mix::Scene::IActorModel** ppModel ) = 0;
		//! @brief AN^[f̃t@C쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[in] pSrc ̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppModel 쐬AN^[fn Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateActorModelFromMemory( Mix::Scene::IEffectPackage* pEffectPackage, const wchar_t* pFilePath, const void* pSrc, UInt32 srcSize, Mix::Scene::IActorModel** ppModel ) = 0;

		//! @}

		//! @name eCf
		//! @{

		//! @brief eCft@C쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppModel 쐬eCfn Mix::Scene::ITerrainModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateTerrainModelFromFile( Mix::Scene::IEffectPackage* pEffectPackage, const wchar_t* pFilePath, Mix::Scene::ITerrainModel** ppModel ) = 0;
		//! @brief eCf[_[쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pReader [_[\ Mix::IO::IReader C^[tF[X̃|C^
		//! @param[out] ppModel 쐬eCfn Mix::Scene::ITerrainModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateTerrainModelFromReader( Mix::Scene::IEffectPackage* pEffectPackage, Mix::IO::IReader* pReader, Mix::Scene::ITerrainModel** ppModel ) = 0;
		//! @brief eCf̃t@C쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[in] pSrc ̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppModel 쐬eCfn Mix::Scene::ITerrainModel C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateTerrainModelFromMemory( Mix::Scene::IEffectPackage* pEffectPackage, const wchar_t* pFilePath, const void* pSrc, UInt32 srcSize, Mix::Scene::ITerrainModel** ppModel ) = 0;

		//! @}

		//! @name rWAGtFNg
		//! @{

		//! @brief CgVtgLX^[쐬܂
		//! @param[out] ppLightShaftsCaster 쐬CgVtgLX^[n Mix::Scene::ILightShaftsCaster C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateLightShaftsCaster( Mix::Scene::ILightShaftsCaster** ppLightShaftsCaster, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief EH[^[v[쐬܂
		//! @param[in] halfExtents eXYZ̔̒
		//! @param[in] worldPos [hԂ̈ʒu\ Mix::Vector3 NX
		//! @param[out] ppWaterPool ǉEH[^[v[n Mix::Scene::IWaterPool C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateWaterPool( const Mix::Vector3& halfExtents, Mix::Vector3& worldPos, Mix::Scene::IWaterPool** ppWaterPool, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief EH[^[v[쐬܂
		//! @param[in] pContext ReLXg\ Mix::Scene::IWaterPoolContext C^[tF[X̃|C^
		//! @param[in] worldMat [hs\ Mix::Matrix4x4 NX
		//! @param[out] ppWaterPool ǉEH[^[v[n Mix::Scene::IWaterPool C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateWaterPool( Mix::Scene::IWaterPoolContext* pContext, const Mix::Matrix4x4& worldMat, Mix::Scene::IWaterPool** ppWaterPool, const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name tA
		//! @{

		//! @brief tA쐬܂
		//! @param[out] ppFloor 쐬tAn Mix::Scene::IFloor C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note
		//! normal( 0.0f, 1.0f, 0.0f) offset( 0.0f ) ō쐬܂<br>
		//! ܂쐬ɐꍇ tA̎QƃJE^ +1 ܂
		virtual Boolean CreateFloor( Mix::Scene::IFloor** ppFloor, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief tA쐬܂
		//! @param[in] normal @
		//! @param[in] offset @ւ̃ItZbg
		//! @param[out] ppFloor 쐬tAn Mix::Scene::IFloor C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇ tA̎QƃJE^ +1 ܂
		virtual Boolean CreateFloor( const Mix::Vector3& normal, Float32 offset, Mix::Scene::IFloor** ppFloor, const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name S[Xg
		//! @{

		//! @brief xCVXS[Xg쐬܂
		//! @param[in] pShape VFCv\ Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @param[in] bCollide Փ˂sꍇ True
		//! @param[out] ppGhost ǉS[Xg\ Mix::Scene::IGhost C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note
		//! Փ˂S[Xg( bCollide == True )ƂĒǉꍇ́ARC_[Ƃē삵A<br>
		//! Mix::Scene::IGhost::GetDynamicsObject Ŏ擾łC^[tF[X Mix::Scene::ILibertyCollider ɂȂ܂B<br>
		//! ܂AՓ˂ȂS[Xg( bCollide == False )ƂĒǉꍇ́AZT[Ƃē삵A<br>
		//! Mix::Scene::IGhost::GetDynamicsObject Ŏ擾łC^[tF[X Mix::Scene::ISimpleSensor ɂȂ܂B<br>
		//! <br>
		//! ǉɐS[XǵAQƃJE^ +1 ܂B
		virtual Boolean CreateBasisGhost( Mix::Dynamics::IShape* pShape, Boolean bCollide, Mix::Scene::IGhost** ppGhost, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief Ll}eBbNS[Xg쐬܂
		//! @param[in] height JvZ̍
		//! @param[in] radius JvZ̔a
		//! @param[in] stepHeight i̍
		//! @param[out] ppGhost ǉS[Xg\ Mix::Scene::IGhost C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note
		//! Ll}eBbNLN^[Ƃē삷邽߁AVFCvƂĎgpJvZ͂xłA<br>
		//! Mix::Scene::IGhost::GetDynamicsObject Ŏ擾łC^[tF[X Mix::Scene::ISimpleKinematicCharacter ɂȂ܂B<br>
		//! <br>
		//! ǉɐS[XǵAQƃJE^ +1 ܂B
		virtual Boolean CreateKinematicGhost( Float32 height, Float32 radius, Float32 stepHeight, Mix::Scene::IGhost** ppGhost, const wchar_t* pDebugName = NULL ) = 0;

		//! @}

		//! @name }eA
		//! @{

		//! @brief }eAt@C쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pFilePath }eÃt@CpX
		//! @param[out] ppMaterial 쐬}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateMaterialFromFile( Mix::Scene::IEffectPackage* pEffectPackage, const wchar_t* pFilePath, Mix::Scene::IMaterial** ppMaterial ) = 0;
		//! @brief }eA[_[쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pReader [_[\ Mix::IO::IReader C^[tF[X̃|C^
		//! @param[out] ppMaterial 쐬}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateMaterialFromReader( Mix::Scene::IEffectPackage* pEffectPackage, Mix::IO::IReader* pReader, Mix::Scene::IMaterial** ppMaterial ) = 0;
		//! @brief }eÃt@C쐬܂
		//! @param[in] pEffectPackage GtFNgpbP[W\ Mix::Scene::IEffectPackage C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[in] pSrc ̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppMaterial 쐬}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateMaterialFromMemory( Mix::Scene::IEffectPackage* pEffectPackage, const wchar_t* pFilePath, const void* pSrc, UInt32 srcSize, Mix::Scene::IMaterial** ppMaterial ) = 0;

		//! @}

		//! @name [V
		//! @{

		//! @brief [Vt@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppMotion 쐬[Vn Mix::Scene::IMotion C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateMotionFromFile( const wchar_t* pFilePath, Mix::Scene::IMotion** ppMotion ) = 0;
		//! @brief [Vt@C쐬܂
		//! @param[in] pReader [_[\ Mix::IO::IReader C^[tF[X̃|C^
		//! @param[out] ppMotion 쐬[Vn Mix::Scene::IMotion C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateMotionFromReader( Mix::IO::IReader* pReader, Mix::Scene::IMotion** ppMotion ) = 0;
		//! @brief [Ṽt@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[in] pSrc ̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppMotion 쐬[Vn Mix::Scene::IMotion C^[tF[X̃|C^̃AhX
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateMotionFromMemory( const wchar_t* pFilePath, const void* pSrc, UInt32 srcSize, Mix::Scene::IMotion** ppMotion ) = 0;

		//! @}

		//! @name fobO
		//! @{

		//! @brief fobO : `F擾܂
		//! @param[in] type `F̃^Cv\ Mix::Scene::DEBUG_DRAW_COLOR_TYPE 񋓒萔
		//! @return `F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& Debug_GetDrawColor( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type ) const = 0;
		//! @brief fobO : `Fݒ肵܂
		//! @param[in] type `F̃^Cv\ Mix::Scene::DEBUG_DRAW_COLOR_TYPE 񋓒萔
		//! @param[in] color `F\ Mix::Vector4 NX
		virtual void Debug_SetDrawColor( Mix::Scene::DEBUG_DRAW_COLOR_TYPE type, const Mix::Vector4& color ) = 0;

		//! @}
	};

}}
