#pragma once

//! @file Mix/Scene/IActorNode.h
//! @brief AN^[m[hC^[tF[XCN[ht@C

#include "Mix/Scene/INode.h"

namespace Mix{ namespace Scene{

	//! @class IActorNode
	//! @brief AN^[m[hC^[tF[X
	class IActorNode : public Mix::Scene::INode
	{
	protected:
		//! @brief fXgN^
		virtual ~IActorNode( void ){}

	public:
		//! @brief I[i[擾܂
		//! @param[out] ppOwner I[i[\ Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾I[i[͎QƃJE^ +1 ܂
		virtual Boolean GetOwner( Mix::Scene::IActorModel** ppOwner ) = 0;
		//! @brief I[i[̃|C^擾܂
		//! @return I[i[\ Mix::Scene::IActorModel C^[tF[X̃|C^Ԃ܂
		virtual Mix::Scene::IActorModel* GetOwnerPtr( void ) const = 0;

		//! @brief ẽCfbNX擾܂B
		//! @return e݂ꍇ 0 ȏ̃CfbNXAȊȌꍇ -1 Ԃ܂B
		virtual Int32 GetParentIndex( void ) const = 0;

		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief [JslɃZbg܂
		virtual void ResetLocalMatrix( void ) = 0;

		//! @brief `悪Lǂ擾܂
		//! @return `悪LɂȂĂꍇ True Ԃ܂
		virtual Boolean IsDraw( void ) const = 0;
		//! @brief `Lɂ邩ǂݒ肵܂
		//! @param[in] state `Lɂꍇ True
		//! @param[in] depth Kpm[h̐[( 0Ŏĝݐݒ )
		virtual void SetDraw( Boolean state, UInt32 depth = 0xFFFFFFFF ) = 0;

		//! @brief RC_[p\ǂ擾܂
		//! @return p\ȏꍇ True Ԃ܂
		virtual Boolean ExistsCollider( void ) const = 0;
		//! @brief RC_[擾܂
		//! @param[out] ppCollider 擾RC_[n Mix::Scene::IActorCollider C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetCollider( Mix::Scene::IActorCollider** ppCollider ) = 0;

		//! @brief ZT[̐擾܂
		//! @return ZT[̐Ԃ܂
		virtual UInt32 GetSensorCount( void ) const = 0;
		//! @brief ZT[擾܂
		//! @param[in] index 擾ZT[̃CfbNX
		//! @param[out] ppSensor 擾ZT[n Mix::Scene::IActorSensor C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetSensor( UInt32 index, Mix::Scene::IActorSensor** ppSensor ) = 0;

		//! @brief RXgCg擾܂
		//! @param[in] pName RXgCg̖O
		//! @param[out] ppConstraint 擾RXgCgn Mix::Scene::IActorConstraint C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾ɐꍇ RXgCg̎QƃJE^ +1 ܂
		virtual Boolean GetConstraint( const wchar_t* pName, Mix::Scene::IActorConstraint** ppConstraint ) = 0;
		//! @brief RXgCgǉ܂
		//! @param[in] pName RXgCg̖O
		//! @param[out] ppConstraint ǉRXgCgn Mix::Scene::IActorConstraint C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean AddConstraint( const wchar_t* pName, Mix::Scene::IActorConstraint** ppConstraint ) = 0;
		//! @brief RXgCg폜܂
		//! @param[in] pConstraint 폜RXgCg\ Mix::Scene::IActorConstraint C^[tF[X̃|C^
		//! @note 폜ɐꍇ RXgCg̎QƃJE^ -1 ܂
		virtual void RemoveConstraint( Mix::Scene::IActorConstraint* pConstraint ) = 0;

		//! @brief [U[CfbNX擾܂
		//! @return CfbNXԂ܂
		virtual Int32 GetUserIndex( void )  const = 0;
		//! @brief [U[CfbNXݒ肵܂
		//! @param index CfbNX
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserIndex( Int32 index ) = 0;

		//! @brief [U[|C^擾܂
		//! @return |C^Ԃ܂
		virtual void* GetUserPtr( void ) const = 0;
		//! @brief [U[|C^ݒ肵܂
		//! @param pData |C^
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserPtr( void* pData ) = 0;
	};

}}
