#pragma once

//! @file Mix/Scene/IActorCollider.h"
//! @brief AN^[RC_[C^[tF[XCN[ht@C

#include "Mix/Scene/IKineticCollider.h"
#include "Mix/Dynamics/IRigidBody.h"

namespace Mix{ namespace Scene{

	//! @class IActorCollider
	//! @brief AN^[RC_[C^[tF[X
	class IActorCollider : public Mix::Scene::IKineticCollider
	{
	protected:
		//! @brief fXgN^
		virtual ~IActorCollider( void ) {}

	public:
		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief ݂̃tB^[O[v擾܂
		//! @return ݂̃tB^[O[vԂ܂
		virtual UInt16 GetCurrentFilterGroup( void ) const = 0;
		//! @brief tB^[O[v擾܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( Mix::Dynamics::IRigidBody::STATUS status ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @param[in] value tB^[O[v
		//! @note
		//! l̓RC_[ŎgpĂ郊Wbh{fB̃Xe[^XɂĈقȂ܂B<br>
		//! <pre>
		//! DEFAULT   : Mix::Dynamics::OF_DEFAULT
		//! STATIC    : Mix::Dynamics::OF_STATIC
		//! KINEMATIC : Mix::Dynamics::OF_KINEMATIC
		//! </pre>
		virtual void SetFilterGroup( Mix::Dynamics::IRigidBody::STATUS status, UInt16 value ) = 0;

		//! @brief ݂̃tB^[}XN擾܂
		//! @return ݂̃tB^[}XNԂ܂
		virtual UInt16 GetCurrentFilterMask( void ) const = 0;
		//! @brief tB^[}XN擾܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( Mix::Dynamics::IRigidBody::STATUS status ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] status Wbh{fB̃Xe[^X\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @param[in] value tB^[}XN
		//! @note
		//! l̓RC_[ŎgpĂ郊Wbh{fB̃Xe[^XɂĈقȂ܂B<br>
		//! <pre>
		//! DEFAULT :   Mix::Dynamics::OF_DEFAULT |
		//!             Mix::Dynamics::OF_STATIC |
		//!             Mix::Dynamics::OF_KINEMATIC |
		//!             Mix::Dynamics::OF_SENSOR</pre>
		//! <pre>
		//! STATIC :    Mix::Dynamics::OF_DEFAULT |
		//!             Mix::Dynamics::OF_KINEMATIC |
		//!             Mix::Dynamics::OF_SENSOR |
		//!             Mix::Dynamics::OF_CHARACTER |
		//!             Mix::Dynamics::OF_DEBRIS</pre>
		//! <pre>
		//! KINEMATIC : Mix::Dynamics::OF_DEFAULT |
		//!             Mix::Dynamics::OF_SENSOR</pre>
		virtual void SetFilterMask( Mix::Dynamics::IRigidBody::STATUS status, UInt16 value ) = 0;
	};

}}
