#pragma once

#include "Mix/Plugin/IReader.h"

namespace Mix{ namespace Sound{

	class WaveReader : public Mix::Plugin::IReader
	{
	private:
		Mix::IO::IReader* m_pReader;

	public:
		static WaveReader* CreateInstance( Mix::IO::IReader* pReader );

	private:
		WaveReader( Mix::IO::IReader* pReader );
		virtual ~WaveReader( void );

	public:
		void Destroy( void );
		const wchar_t* GetFilePath( void ) const;

	public:
		virtual unsigned long long GetSize( void ) const;
		virtual unsigned long long GetPosition( void ) const;
		virtual unsigned int Read( void* pBuffer, unsigned int readSize );
		virtual const void* Read( unsigned int readSize, unsigned int& result );
		virtual unsigned long long Seek( Mix::Plugin::IReader::SEEK_METHOD method, unsigned long long distance );
	};

}}