#include "Mix/Private/Sound/WaveReader.h"
#include "Mix/IO/IReader.h"

namespace Mix{ namespace Sound{

WaveReader* WaveReader::CreateInstance( Mix::IO::IReader* pReader )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SOUND, WaveReader, pReader );
}

WaveReader::WaveReader( Mix::IO::IReader* pReader ) :
m_pReader( NULL )
{
	MIX_ASSERT( pReader != NULL );

	MIX_ADD_REF( pReader );
	m_pReader = pReader;
}

WaveReader::~WaveReader( void )
{
	MIX_RELEASE( m_pReader );
}

void WaveReader::Destroy( void )
{
	MIX_LIB_DELETE_THIS_T( WaveReader, this );
}

const wchar_t* WaveReader::GetFilePath( void ) const
{
	return m_pReader->GetFilePath();
}

unsigned long long WaveReader::GetSize( void ) const
{
	return m_pReader->GetSize();
}

unsigned long long WaveReader::GetPosition( void ) const
{
	return m_pReader->GetPos();
}

unsigned int WaveReader::Read( void* pBuffer, unsigned int readSize )
{
	return m_pReader->Read( pBuffer, readSize );
}

const void* WaveReader::Read( unsigned int readSize, unsigned int& result )
{
	return NULL;
}

unsigned long long WaveReader::Seek( Mix::Plugin::IReader::SEEK_METHOD method, unsigned long long distance )
{
	Mix::IO::SEEK_METHOD ioSeekMethod;

	switch( method )
	{
	case Mix::Plugin::IReader::BEGIN:
		ioSeekMethod = Mix::IO::SEEK_METHOD_BEGIN;
		break;
	case Mix::Plugin::IReader::CURRENT:
		ioSeekMethod = Mix::IO::SEEK_METHOD_CURRENT;
		break;
	case Mix::Plugin::IReader::END:
		ioSeekMethod = Mix::IO::SEEK_METHOD_END;
		break;
	}

	return m_pReader->Seek( ioSeekMethod, distance );
}

}}
