#pragma once

#include "Mix/Private/Sound/BaseMediator.h"

namespace Mix{ namespace Sound{

	class StreamingControllerMediator : public Mix::Sound::BaseMediator
	{
	private:
		class SyncFloat
		{
		private:
			Mix::CriticalSection m_Sync;
			Float32 m_Current;
			Float32 m_Next;

		public:
			SyncFloat( Float32 defValue );

		public:
			void SetNext( Float32 value );
			Float32 GetNext( void );

		public:
			Boolean GetCurrent( Float32& value );
		};

	public:
		static StreamingControllerMediator* CreateInstance( void );

	private:
		StreamingControllerMediator::SyncFloat m_Volume;
		StreamingControllerMediator::SyncFloat m_Panpot;

	private:
		StreamingControllerMediator( void );
		virtual ~StreamingControllerMediator( void );

	public:
		void SetVolume( Float32 value );
		void SetPanpot( Float32 value );
		Float32 GetVolume( void );
		Float32 GetPanpot( void );

	public:
		Boolean GetVolume( Float32& value );
		Boolean GetPanpot( Float32& value );
	};
}}
