#pragma once

#include "Mix/Private/Sound/Task.h"

namespace Mix{ namespace Sound{

	class EmitterMediator;

	class SimpleEmitterTask : public Mix::Sound::Task
	{
	private:
		Mix::Sound::EmitterMediator* m_pMediator;
		IXAudio2SourceVoice* m_pVoice;
		Mix::Memory::IBuffer* m_pBuffer;
		XAUDIO2_BUFFER m_Data;
		Int32 m_SuspendCount;

	private:
		void ProcPlay( Boolean bLoop );
		void ProcStop( void );
		void ProcSuspend( void );
		void ProcResume( void );
		void ProcState( void );

	public:
		MIX_DECLARE_ALLOCATOR();

		SimpleEmitterTask( Mix::Sound::EmitterMediator* pMediator, Mix::Memory::IBuffer* pBuffer, IXAudio2SourceVoice* pVoice );
		virtual ~SimpleEmitterTask( void );

	public:
		virtual Boolean Process( void );
	};

}}
