#pragma once

#include "Mix/Private/Sound/Types.h"
#include "Mix/Private/Sound/BaseMediator.h"

namespace Mix{ namespace Sound{

	class Manager;

	class EmitterMediator : public Mix::Sound::BaseMediator
	{
	public:
		static EmitterMediator* CreateInstance( Mix::Sound::PX3DAudioCalculate pCalcFunc,
													const X3DAUDIO_HANDLE& handle,
													UInt32 masterChannels,
													UInt32 channels );

	private:
		Mix::Sound::PX3DAudioCalculate m_pCalcFunc;
		X3DAUDIO_HANDLE m_Handle;

		Mix::CriticalSection m_Sync;
		X3DAUDIO_DSP_SETTINGS m_DSPSettings;
		Mix::STL::Vector<Mix::Memory::SECTION_SOUND, Float32> m_Matrix;

	private:
		EmitterMediator(	Mix::Sound::PX3DAudioCalculate pCalcFunc,
								const X3DAUDIO_HANDLE& handle,
								UInt32 masterChannels,
								UInt32 channels );

		virtual ~EmitterMediator( void );

	public:
		void UpdateDSPSettings( const X3DAUDIO_LISTENER& lp, const X3DAUDIO_EMITTER& ep );

	public:
		void ApplyDSPSettings( IXAudio2SourceVoice* pVoice );
	};

}}
