#include <Mix/Semaphore.h>

namespace Mix{

Semaphore::Semaphore( UInt32 ui32InitCount, UInt32 ui32MaxCount ) : m_hSema( NULL )
{
	m_hSema = ::CreateSemaphore( NULL, ui32InitCount, ui32MaxCount, NULL );
}

Semaphore::~Semaphore( void )
{
	if( m_hSema != NULL )
	{
		::CloseHandle( m_hSema );
	}
}

Boolean Semaphore::Reduce( UInt32 ui32TimeOut )
{
	UInt32 ret = ::WaitForSingleObject( m_hSema, ui32TimeOut );
	return ( ret == WAIT_OBJECT_0 )? True : False;
}

void Semaphore::Increase( UInt32 ui32Count )
{
	::ReleaseSemaphore( m_hSema, ui32Count, NULL );
}

HANDLE Semaphore::GetHandle( void ) const
{
	return m_hSema;
}

}
