#include "Mix/Private/Scene/Standard/DX9/EffectPackage.h"
#include "Mix/Private/Scene/Standard/DX9/EffectResource.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX9{

EffectPackage* EffectPackage::CreateInstance( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SCENE, EffectPackage, pDirPath, pName, pFilePath );
}

EffectPackage::EffectPackage( const wchar_t* pDirPath, const wchar_t* pName, const wchar_t* pFilePath ) :
	Mix::Scene::Standard::Common::EffectPackage( pDirPath, pName, pFilePath )
{
}

EffectPackage::~EffectPackage( void )
{
}

void EffectPackage::GetShaderBinary( EffectPackage::SHADER_TYPES type, EffectPackage::SHADER_BINARY& out )
{
	switch( type )
	{
	// Misc //

	case EffectPackage::SHADER_SAMPLING_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Sampling(DX9_3)" );
		out.pData = &( MEP_VS_SAMPLING_3[0] );
		out.dataSize = sizeof( MEP_VS_SAMPLING_3 );
		break;
	case EffectPackage::SHADER_SAMPLING_COPY_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingCopy(DX9_3)" );
		out.pData = &( MEP_PS_SAMPLING_COPY_3[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_COPY_3 );
		break;
	case EffectPackage::SHADER_SAMPLING_DOWN2X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingDown2x(DX9_3)" );
		out.pData = &( MEP_PS_SAMPLING_DOWN2X_3[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_DOWN2X_3 );
		break;
	case EffectPackage::SHADER_SAMPLING_DOWN4X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SamplingDown4x(DX9_3)" );
		out.pData = &( MEP_PS_SAMPLING_DOWN4X_3[0] );
		out.dataSize = sizeof( MEP_PS_SAMPLING_DOWN4X_3 );
		break;

	case EffectPackage::SHADER_BLUR3X_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur3x_X(DX9_3)" );
		out.pData = &( MEP_PS_BLUR3X_X_3[0] );
		out.dataSize = sizeof( MEP_PS_BLUR3X_X_3 );
		break;
	case EffectPackage::SHADER_BLUR3X_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur3x_Y(DX9_3)" );
		out.pData = &( MEP_PS_BLUR3X_Y_3[0] );
		out.dataSize = sizeof( MEP_PS_BLUR3X_Y_3 );
		break;

	case EffectPackage::SHADER_BLUR5X_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur5x_X(DX9_3)" );
		out.pData = &( MEP_PS_BLUR5X_X_3[0] );
		out.dataSize = sizeof( MEP_PS_BLUR5X_X_3 );
		break;
	case EffectPackage::SHADER_BLUR5X_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Blur5x_Y(DX9_3)" );
		out.pData = &( MEP_PS_BLUR5X_Y_3[0] );
		out.dataSize = sizeof( MEP_PS_BLUR5X_Y_3 );
		break;

	case EffectPackage::SHADER_GAUSSIAN_BLUR_X_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX9_3)" );
		out.pData = &( MEP_VS_GAUSSIAN_BLUR_X_3[0] );
		out.dataSize = sizeof( MEP_VS_GAUSSIAN_BLUR_X_3 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_X_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX9_3)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_X_3[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_X_3 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_Y_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX9_3)" );
		out.pData = &( MEP_VS_GAUSSIAN_BLUR_Y_3[0] );
		out.dataSize = sizeof( MEP_VS_GAUSSIAN_BLUR_Y_3 );
		break;
	case EffectPackage::SHADER_GAUSSIAN_BLUR_Y_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX9_3)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_Y_3[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_Y_3 );
		break;

	case EffectPackage::SHADER_GAUSSIAN_BLUR_EX_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"GaussianBlurEx(DX9_3)" );
		out.pData = &( MEP_PS_GAUSSIAN_BLUR_EX_3[0] );
		out.dataSize = sizeof( MEP_PS_GAUSSIAN_BLUR_EX_3 );
		break;

	case EffectPackage::SHADER_BP____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPass__(DX9_3)" );
		out.pData = &( MEP_PS_BRIGHTPASS____3[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS____3 );
		break;
	case EffectPackage::SHADER_BP_L__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPassL_(DX9_3)" );
		out.pData = &( MEP_PS_BRIGHTPASS_L__3[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS_L__3 );
		break;
	case EffectPackage::SHADER_BP_LA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"BrightPassLA(DX9_3)" );
		out.pData = &( MEP_PS_BRIGHTPASS_LA_3[0] );
		out.dataSize = sizeof( MEP_PS_BRIGHTPASS_LA_3 );
		break;

	// SkyDome //

	case EffectPackage::SHADER_SKYDOME_DEFAULT_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX9_3)" );
		out.pData = &( MEP_VS_SKYDOME_DEFAULT_3[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_DEFAULT_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT______PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT______3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT______3 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT__C___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C--- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT__C___3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT__C___3 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT__C2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C2- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT__C2__3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT__C2__3 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_B____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default B--- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_B____3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_B____3 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_BC___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC-- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_BC___3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_BC___3 );
		break;
	case EffectPackage::SHADER_SKYDOME_DEFAULT_BC2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC2- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_DEFAULT_BC2__3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_DEFAULT_BC2__3 );
		break;

	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX9_3)" );
		out.pData = &( MEP_VS_SKYDOME_ATMOSPHERE_3[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_ATMOSPHERE_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE______PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE______3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE______3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C___3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C___3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--L (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C_L_3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C_L_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C2__3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C2__3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE__C2L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2L (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE__C2L_3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE__C2L_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_B____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere B--- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_B____3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_B____3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC___3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC___3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-L (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC_L_3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC_L_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC2__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC2__3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC2__3 );
		break;
	case EffectPackage::SHADER_SKYDOME_ATMOSPHERE_BC2L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2L (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_ATMOSPHERE_BC2L_3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_ATMOSPHERE_BC2L_3 );
		break;

	case EffectPackage::SHADER_SKYDOME_PANORAMA_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX9_3)" );
		out.pData = &( MEP_VS_SKYDOME_PANORAMA_3[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_PANORAMA_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FA_VS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX9_3)" );
		out.pData = &( MEP_VS_SKYDOME_PANORAMA_FA_3[0] );
		out.dataSize = sizeof( MEP_VS_SKYDOME_PANORAMA_FA_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FD_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FD (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_FD_3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_FD_3 );
		break;
	case EffectPackage::SHADER_SKYDOME_PANORAMA_FA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX9_3)" );
		out.pData = &( MEP_PS_SKYDOME_PANORAMA_FA_3[0] );
		out.dataSize = sizeof( MEP_PS_SKYDOME_PANORAMA_FA_3 );
		break;

	// PostEffect //

	case EffectPackage::SHADER_SSAO_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SSAO(DX9_3)" );
		out.pData = &( MEP_PS_SSAO_3[0] );
		out.dataSize = sizeof( MEP_PS_SSAO_3 );
		break;
	case EffectPackage::SHADER_SSAO_TEX_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SSAO_Tex(DX9_3)" );
		out.pData = &( MEP_PS_SSAO_TEX_3[0] );
		out.dataSize = sizeof( MEP_PS_SSAO_TEX_3 );
		break;

	case EffectPackage::SHADER_SM_FINISH____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish -- (DX9_3)" );
		out.pData = &( MEP_PS_SM_FINISH____3[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH____3 );
		break;
	case EffectPackage::SHADER_SM_FINISH__B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish -B (DX9_3)" );
		out.pData = &( MEP_PS_SM_FINISH__B_3[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH__B_3 );
		break;
	case EffectPackage::SHADER_SM_FINISH_R__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish R- (DX9_3)" );
		out.pData = &( MEP_PS_SM_FINISH_R__3[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH_R__3 );
		break;
	case EffectPackage::SHADER_SM_FINISH_RB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"SM_Finish RB (DX9_3)" );
		out.pData = &( MEP_PS_SM_FINISH_RB_3[0] );
		out.dataSize = sizeof( MEP_PS_SM_FINISH_RB_3 );
		break;

	case EffectPackage::SHADER_UNDER_WATER_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"UnderWater(DX9_3)" );
		out.pData = &( MEP_PS_UNDER_WATER_3[0] );
		out.dataSize = sizeof( MEP_PS_UNDER_WATER_3 );
		break;

	case EffectPackage::SHADER_LUM_TRANSFORM_INITAL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Inital(DX9_3)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_INITAL_3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_INITAL_3 );
		break;
	case EffectPackage::SHADER_LUM_TRANSFORM_ITERATE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Iterate(DX9_3)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_ITERATE_3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_ITERATE_3 );
		break;
	case EffectPackage::SHADER_LUM_TRANSFORM_FINAL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumTransform_Final(DX9_3)" );
		out.pData = &( MEP_PS_LUM_TRANSFORM_FINAL_3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_TRANSFORM_FINAL_3 );
		break;
	case EffectPackage::SHADER_LUM_ADAPTED_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumAdapted(DX9_3)" );
		out.pData = &( MEP_PS_LUM_ADAPTED_3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_ADAPTED_3 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR___B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperator__B(DX9_3)" );
		out.pData = &( MEP_PS_LUM_OPERATOR___B_3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR___B_3 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_T___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorT__(DX9_3)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_T___3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_T___3 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_T_B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorT_B(DX9_3)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_T_B_3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_T_B_3 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_TA__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorTA_(DX9_3)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_TA__3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_TA__3 );
		break;
	case EffectPackage::SHADER_LUM_OPERATOR_TAB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LumOperatorTAB(DX9_3)" );
		out.pData = &( MEP_PS_LUM_OPERATOR_TAB_3[0] );
		out.dataSize = sizeof( MEP_PS_LUM_OPERATOR_TAB_3 );
		break;

	case EffectPackage::SHADER_LS_INIT___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsInit_(DX9_3)" );
		out.pData = &( MEP_PS_LS_INIT___3[0] );
		out.dataSize = sizeof( MEP_PS_LS_INIT___3 );
		break;
	case EffectPackage::SHADER_LS_INIT_A_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsInitA(DX9_3)" );
		out.pData = &( MEP_PS_LS_INIT_A_3[0] );
		out.dataSize = sizeof( MEP_PS_LS_INIT_A_3 );
		break;
	case EffectPackage::SHADER_LS_BLUR_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Low(DX9_3)" );
		out.pData = &( MEP_PS_LS_BLUR_L_3[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_L_3 );
		break;
	case EffectPackage::SHADER_LS_BLUR_M_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Middle(DX9_3)" );
		out.pData = &( MEP_PS_LS_BLUR_M_3[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_M_3 );
		break;
	case EffectPackage::SHADER_LS_BLUR_H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_High(DX9_3)" );
		out.pData = &( MEP_PS_LS_BLUR_H_3[0] );
		out.dataSize = sizeof( MEP_PS_LS_BLUR_H_3 );
		break;

	case EffectPackage::SHADER_LF_IMAGE____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image___(DX9_3)" );
		out.pData = &( MEP_PS_LF_IMAGE____3[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE____3 );
		break;
	case EffectPackage::SHADER_LF_IMAGE__H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_H(DX9_3)" );
		out.pData = &( MEP_PS_LF_IMAGE__H_3[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE__H_3 );
		break;
	case EffectPackage::SHADER_LF_IMAGE_G__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_G_(DX9_3)" );
		out.pData = &( MEP_PS_LF_IMAGE_G__3[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE_G__3 );
		break;
	case EffectPackage::SHADER_LF_IMAGE_GH_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ImageGH(DX9_3)" );
		out.pData = &( MEP_PS_LF_IMAGE_GH_3[0] );
		out.dataSize = sizeof( MEP_PS_LF_IMAGE_GH_3 );
		break;
	case EffectPackage::SHADER_LF_MODIFY____PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify__(DX9_3)" );
		out.pData = &( MEP_PS_LF_MODIFY____3[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY____3 );
		break;
	case EffectPackage::SHADER_LF_MODIFY_D__PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyD_(DX9_3)" );
		out.pData = &( MEP_PS_LF_MODIFY_D__3[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY_D__3 );
		break;
	case EffectPackage::SHADER_LF_MODIFY__B_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify_B(DX9_3)" );
		out.pData = &( MEP_PS_LF_MODIFY__B_3[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY__B_3 );
		break;
	case EffectPackage::SHADER_LF_MODIFY_DB_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyDB(DX9_3)" );
		out.pData = &( MEP_PS_LF_MODIFY_DB_3[0] );
		out.dataSize = sizeof( MEP_PS_LF_MODIFY_DB_3 );
		break;

	case EffectPackage::SHADER_FI_HEJL_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FilmicHejl(DX9_3)" );
		out.pData = &( MEP_PS_FILMIC_HEJL_3[0] );
		out.dataSize = sizeof( MEP_PS_FILMIC_HEJL_3 );
		break;
	case EffectPackage::SHADER_FI_HABLE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FilmicHable(DX9_3)" );
		out.pData = &( MEP_PS_FILMIC_HABLE_3[0] );
		out.dataSize = sizeof( MEP_PS_FILMIC_HABLE_3 );
		break;

	case EffectPackage::SHADER_GAMMA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Gamma(DX9_3)" );
		out.pData = &( MEP_PS_GAMMA_3[0] );
		out.dataSize = sizeof( MEP_PS_GAMMA_3 );
		break;

	case EffectPackage::SHADER_CAM_MOTION_BLUR_L_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_Low(DX9_3)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_L_3[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_L_3 );
		break;
	case EffectPackage::SHADER_CAM_MOTION_BLUR_M_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_Middle(DX9_3)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_M_3[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_M_3 );
		break;
	case EffectPackage::SHADER_CAM_MOTION_BLUR_H_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"CameraMotionBlur_High(DX9_3)" );
		out.pData = &( MEP_PS_CAM_MOTION_BLUR_H_3[0] );
		out.dataSize = sizeof( MEP_PS_CAM_MOTION_BLUR_H_3 );
		break;

	case EffectPackage::SHADER_CA_IMAGE___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_Image_(DX9_3)" );
		out.pData = &( MEP_PS_CA_IMAGE___3[0] );
		out.dataSize = sizeof( MEP_PS_CA_IMAGE___3 );
		break;
	case EffectPackage::SHADER_CA_IMAGE_K_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_ImageK(DX9_3)" );
		out.pData = &( MEP_PS_CA_IMAGE_K_3[0] );
		out.dataSize = sizeof( MEP_PS_CA_IMAGE_K_3 );
		break;
	case EffectPackage::SHADER_CA_FINISH___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_Finish_(DX9_3)" );
		out.pData = &( MEP_PS_CA_FINISH___3[0] );
		out.dataSize = sizeof( MEP_PS_CA_FINISH___3 );
		break;
	case EffectPackage::SHADER_CA_FINISH_D_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Chromatism_FinishD(DX9_3)" );
		out.pData = &( MEP_PS_CA_FINISH_D_3[0] );
		out.dataSize = sizeof( MEP_PS_CA_FINISH_D_3 );
		break;

	case EffectPackage::SHADER_DOF_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"DepthOfField(DX9_3)" );
		out.pData = &( MEP_PS_DOF_3[0] );
		out.dataSize = sizeof( MEP_PS_DOF_3 );
		break;

	case EffectPackage::SHADER_LENS_DIST___PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensDistortion_(DX9_3)" );
		out.pData = &( MEP_PS_LENS_DIST___3[0] );
		out.dataSize = sizeof( MEP_PS_LENS_DIST___3 );
		break;
	case EffectPackage::SHADER_LENS_DIST_K_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"LensDistortionK(DX9_3)" );
		out.pData = &( MEP_PS_LENS_DIST_K_3[0] );
		out.dataSize = sizeof( MEP_PS_LENS_DIST_K_3 );
		break;

	case EffectPackage::SHADER_VIGNETTE_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"Vignette(DX9_3)" );
		out.pData = &( MEP_PS_VIGNETTE_PS[0] );
		out.dataSize = sizeof( MEP_PS_VIGNETTE_PS );
		break;

	case EffectPackage::SHADER_AA_FXAA_PS:
		::wcscpy_s( out.name, EffectPackage::SHADER_BINARY::NAME_SIZE, L"FXAA(DX9_3)" );
		out.pData = &( MEP_PS_FXAA_3[0] );
		out.dataSize = sizeof( MEP_PS_FXAA_3 );
		break;

	default:
		MIX_ERROR_W( L"w肳ꂽ풓VF[_[݂͑܂(DX9_3)" );
	};
}

}}}}
