#pragma once

#include "Mix/Scene/IHemisphereLight.h"
#include "Mix/Private/Scene/Common/RendererObject.h"

namespace Mix{ namespace Scene{ namespace Common{

	class HemisphereLight : public Mix::Scene::IHemisphereLight, public Mix::Scene::Common::RendererObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::HemisphereLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

	private:
		Mix::Vector3 m_Axis;
		Mix::Vector4 m_GroundColor;
		Mix::Vector4 m_SkyColor;
		Boolean m_bEnabled;

	public:
		static HemisphereLight* CreateInstance( void );

	private:
		HemisphereLight( void );
		virtual ~HemisphereLight( void );

	public:
		void Attach( void );
		void Detach( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IHemisphereLight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector3& GetAxis( void ) const;
		virtual void SetAxis( const Mix::Vector3& axis );

		virtual const Mix::Vector4& GetGroundColor( void ) const;
		virtual void SetGroundColor( const Mix::Vector4& color );

		virtual const Mix::Vector4& GetSkyColor( void ) const;
		virtual void SetSkyColor( const Mix::Vector4& color );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILight
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsEnabled( void ) const;
		virtual void SetEnabled( Boolean state );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
		virtual Boolean IsRendering( void ) const;

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}}
