#pragma once

#include "Mix/Scene/IGhost.h"
#include "Mix/Private/Scene/Common/RendererObject.h"

namespace Mix{ namespace Dynamics{
	class IWorld;
	class IObject;
	class IObjectListener;
}}

namespace Mix{ namespace Scene{ namespace Common{

	class DynamicsObject;

	class Ghost : public Mix::Scene::IGhost, public Mix::Scene::Common::RendererObject
	{
	private:
		Int32 m_UserIndex;
		void* m_pUserPtr;

	protected:
		Ghost( void );
		virtual ~Ghost( void );

	public:
		void Attach( void );
		void Detach( void );

		virtual void AttachDynamics( Mix::Dynamics::IWorld* pWorld, Mix::Dynamics::IObjectListener* pObjectListener ) = 0;
		virtual void DetachDynamics( Mix::Dynamics::IWorld* pWorld ) = 0;

		virtual Mix::Dynamics::IObject* GetInternalObjectPtr( void ) const = 0;

	public:
		/*
			Mix::Scene::IGhost
		*/

		virtual Int32 GetUserIndex( void )  const;
		virtual void SetUserIndex( Int32 index );

		virtual void* GetUserPtr( void ) const;
		virtual void SetUserPtr( void* pData );

		virtual Float32 Debug_GetDrawAxisScaling( void ) const;
		virtual void Debug_SetDrawAxisScaling( Float32 scaling );

		/*
			Mix::Scene::IRendererObject
		*/

		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
		virtual Boolean IsRendering( void ) const;

	public:
		static const wchar_t* FAILED_ADD;
	};

}}}
