#include "Mix/Private/Scene/Common/Ghost.h"

#include "Mix/Dynamics/IObject.h"
#include "Mix/Private/Scene/Common/DynamicsObject.h"

namespace Mix{ namespace Scene{ namespace Common{

const wchar_t* Ghost::FAILED_ADD = L"S[Xg̒ǉɎs";

Ghost::Ghost( void ) :
m_UserIndex( 0 ),
m_pUserPtr( NULL )
{
}

Ghost::~Ghost( void )
{
}

void Ghost::Attach( void )
{
	RendererObject::SetRendering( True );
}

void Ghost::Detach( void )
{
	RendererObject::SetRendering( False );
}

Int32 Ghost::GetUserIndex( void )  const
{
	return m_UserIndex;
}

void Ghost::SetUserIndex( Int32 index )
{
	m_UserIndex = index;
}

void* Ghost::GetUserPtr( void ) const
{
	return m_pUserPtr;
}

void Ghost::SetUserPtr( void* pData )
{
	m_pUserPtr = pData;
}

Float32 Ghost::Debug_GetDrawAxisScaling( void ) const
{
#ifdef _DEBUG

	Mix::Dynamics::IObject* pInternalObject = GetInternalObjectPtr();
	if( pInternalObject != NULL )
	{
		return pInternalObject->Debug_GetDrawAxisScaling();
	}

#endif //_DEBUG

	return 0.0f;
}

void Ghost::Debug_SetDrawAxisScaling( Float32 scaling )
{
#ifdef _DEBUG

	Mix::Dynamics::IObject* pInternalObject = GetInternalObjectPtr();
	if( pInternalObject != NULL )
	{
		pInternalObject->Debug_SetDrawAxisScaling( scaling );
	}

#endif //_DEBUG
}

Mix::Scene::IRendererObject::TYPE Ghost::GetType( void ) const
{
	return Mix::Scene::IRendererObject::GHOST;
}

Boolean Ghost::IsRendering( void ) const
{
	return RendererObject::IsRendering();
}

}}}
