#pragma once

#include "Mix/Private/Scene/Common/ActorDynamicsCluster.h"

namespace Mix{ namespace Scene{ namespace Common{

	class ActorDynamicsPart : public Mix::Scene::Common::ActorDynamicsCluster
	{
	public:
		static ActorDynamicsPart* CreateInstance( void );

	private:
		Boolean m_bJointCollisionDisabled;
		Mix::Matrix4x4 m_JointLocalPivotB;
		Mix::Dynamics::IJoint* m_pJoint;

	private:
		ActorDynamicsPart( void );
		virtual ~ActorDynamicsPart( void );

	public:
		void SetJoint( Boolean bCollisionDisabled, const Mix::Matrix4x4& localPivotB, Mix::Dynamics::IJoint* pJoint );
		Mix::Dynamics::IJoint* GetJointPtr( void ) const;

		ActorDynamicsPart* Clone( void );
		Boolean CloneFinish( std::map<Mix::Dynamics::IRigidBody*, Mix::Dynamics::IRigidBody*>& rbBMap, ActorDynamicsPart* pCloneCluster, const wchar_t* pDebugName );

	protected:
		virtual void OnColliderStateChanged( Boolean state );
		virtual void OnColliderModeChanged( Mix::Scene::DYNAMICS_COLLIDER_MODE mode );

	public:
		virtual void SetLink( Mix::Scene::IRendererObject* pOwner, Mix::Matrix4x4* pParentWorldMat, Mix::Matrix4x4* pWorldMat );

		virtual void AttachToWorld( Mix::Dynamics::IWorld* pWorld, Mix::Dynamics::IObjectListener* pObjectListener );
		virtual void DetachFromWorld( Mix::Dynamics::IWorld* pWorld );

		virtual void ResetChild( const Mix::Matrix4x4& baseMat );

		virtual Boolean NeedsUpdateChild( void ) const;
		virtual void UpdateChild( const Mix::Matrix4x4& baseMat );

#ifdef _DEBUG
		virtual void Debug_Draw(	UInt32 flags,
									Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
									Float32 axisScaling,
									Float32 jointFrameMinSize,
									Float32 jointLimitScaling );
#endif //_DEBUG
	};

}}}
