#pragma once

#include "Mix/Private/Scene/Common/ActorDynamicsCluster.h"

namespace Mix{ namespace Scene{ namespace Common{

	class ActorDynamicsFigure : public Mix::Scene::Common::ActorDynamicsCluster
	{
	public:
		static ActorDynamicsFigure* CreateInstance( void );

	private:
		Mix::Scene::Common::ActorKinematicCharacter* m_pKinematicCharacter;

		Mix::Matrix4x4 m_ReceiveMotionMat;
		Mix::Scene::Common::ActorDynamicsCluster* m_pCastMotionCluster;

	private:
		ActorDynamicsFigure( void );
		virtual ~ActorDynamicsFigure( void );

	protected:
		virtual void OnCharacterStateChanged( Boolean state ) {}
		virtual void OnCharacterModeChanged( Mix::Scene::DYNAMICS_KCHAR_MODE mode ) {}

	public:
		Mix::Scene::Common::ActorKinematicCharacter* GetCharacterPtr( void ) const;
		void SetCharacter( Mix::Scene::Common::ActorKinematicCharacter* pKinematicCharacter );

		Boolean IsCharacterEnabled( void ) const;
		void SetCharacterEnabled( Boolean state );
		void SetCharacterMode( Mix::Scene::DYNAMICS_KCHAR_MODE mode );

		void SetReceiveMotionMatrix( const Mix::Matrix4x4& mat );
		void SetCastMotionCluster( Mix::Scene::Common::ActorDynamicsCluster* pCluster );

		Boolean IsControl_Ragdoll( void ) const;
		Boolean IsControl_Character( void ) const;

		void Idling( void );

		ActorDynamicsFigure* Clone( void );

	public:
		virtual void SetLink( Mix::Scene::IRendererObject* pOwner, Mix::Matrix4x4* pParentWorldMat, Mix::Matrix4x4* pWorldMat );

		virtual Boolean IsCollide( void ) const;
		virtual Boolean IsControl( void ) const;
		virtual Boolean IsActive( void ) const;

		virtual void AttachToWorld( Mix::Dynamics::IWorld* pWorld, Mix::Dynamics::IObjectListener* pObjectListener );
		virtual void DetachFromWorld( Mix::Dynamics::IWorld* pWorld );

		virtual void ResetChild( const Mix::Matrix4x4& baseMat );

		virtual Boolean NeedsUpdateChild( void ) const;
		virtual void UpdateChild( const Mix::Matrix4x4& baseMat );

		virtual Boolean Refresh( void );

		virtual void Dispose( void );

#ifdef _DEBUG
		virtual void Debug_Draw(	UInt32 flags,
									Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
									Float32 axisScaling,
									Float32 jointFrameMinSize,
									Float32 jointLimitScaling );
#endif //_DEBUG
	};

}}}
