#include "Mix/Point.h"

namespace Mix {

Point::Point( void )
{
	x = 0;
	y = 0;
}

Point::Point( Int32 px, Int32 py )
{
	x = px;
	y = py;
}

Point::Point( const Point& pp )
{
	x = pp.x;
	y = pp.y;
}

Point::Point( const Vector2& pp )
{
	x = static_cast<Int32>( pp.x );
	y = static_cast<Int32>( pp.y );
}

Boolean Point::operator == ( const Point& pp ) const
{
	if( ( x != pp.x ) ||
		( y != pp.y ) )
	{
		return False;
	}

	return True;
}

Boolean Point::operator != ( const Point& pp ) const
{
	if( ( x != pp.x ) ||
		( y != pp.y ) )
	{
		return True;
	}

	return False;
}

Point& Point::operator = ( const Point& pp )
{
	x = pp.x;
	y = pp.y;

	return *this;
}

Point& Point::operator = ( const Vector2& pp )
{
	x = static_cast<Int32>( pp.x );
	y = static_cast<Int32>( pp.y );

	return *this;
}

Point& Point::operator += ( const Point& pp )
{
	x += pp.x;
	y += pp.y;

	return *this;
}

Point& Point::operator -= ( const Point& pp )
{
	x -= pp.x;
	y -= pp.y;

	return *this;
}

Point& Point::operator *= ( const Point& pp )
{
	x *= pp.x;
	y *= pp.y;

	return *this;
}

Point& Point::operator /= ( const Point& pp )
{
	x = ( pp.x == 0 )? ( 0 ) : ( x / pp.x );
	y = ( pp.y == 0 )? ( 0 ) : ( y / pp.y );

	return *this;
}

Point Point::operator + ( const Point& pp ) const
{
	Point tmp( *this );
	tmp += pp;
	return tmp;
}

Point Point::operator - ( const Point& pp ) const
{
	Point tmp( *this );
	tmp -= pp;
	return tmp;
}

Point Point::operator * ( const Point& pp ) const
{
	Point tmp( *this );
	tmp *= pp;
	return tmp;
}

Point Point::operator / ( const Point& pp ) const
{
	Point tmp( *this );
	tmp /= pp;
	return tmp;
}

Point Point::operator -( void ) const
{
	return ( *this * -1 );
}

Point& Point::operator *= ( Int32 s )
{
	x *= s;
	y *= s;

	return *this;
}

Point& Point::operator /= ( Int32 s )
{
	if( s == 0 )
	{
		x = 0;
		y = 0;
	}
	else
	{
		x /= s;
		y /= s;
	}

	return *this;
}

Point Point::operator * ( Int32 s ) const
{
	Point tmp( *this );
	tmp *= s;
	return tmp;
}

Point Point::operator / ( Int32 s ) const
{
	Point tmp( *this );
	tmp /= s;
	return tmp;
}

void Point::Set( Int32 px, Int32 py )
{
	x = px;
	y = py;
}

Point Point::Min( const Point& p0, const Point& p1 )
{
	Point tmp = p0;

	if( tmp.x > p1.x ) { tmp.x = p1.x; }
	if( tmp.y > p1.y ) { tmp.y = p1.y; }

	return tmp;
}

Point Point::Max( const Point& p0, const Point& p1 )
{
	Point tmp = p0;

	if( tmp.x < p1.x ) { tmp.x = p1.x; }
	if( tmp.y < p1.y ) { tmp.y = p1.y; }

	return tmp;
}

}
