#pragma once

#include "Mix/Private/HID/Gamepad.h"

namespace Mix{ namespace HID{ namespace DX{

	class Gamepad : public Mix::HID::Gamepad
	{
	public:
		static Gamepad* CreateInstance( LPDIRECTINPUTDEVICE8 pDevice, Boolean bPolling );

	private:
		//foCXXe[^X
		enum STATUS
		{
			STATUS_ACQUIRE	= 0,	//Jn
			STATUS_POLL		= 1,	//|[O
			STATUS_FINISH	= 2,	//I
		};

	public:
		LPDIRECTINPUTDEVICE8 m_pDevice;
		Boolean m_bPolling;
		DI_GAMEPAD_DATA m_Data;
		STATUS m_Status;
		Int32 m_ButtonList[Mix::HID::DI_BUTTON_MAX * 2];
		Int32 m_PovList[Mix::HID::DI_POV_MAX * 2];
		UInt32 m_ButtonRefTable[Mix::HID::GAMEPAD_BUTTON_MAX];
		UInt32 m_TriggerRefTable[Mix::HID::GAMEPAD_FINGER_MAX];
		Mix::Vector2 m_Stick[Mix::HID::GAMEPAD_FINGER_MAX];
		Boolean m_bAvailable;

	private:
		Gamepad( LPDIRECTINPUTDEVICE8 pDevice, Boolean bPolling );
		virtual ~Gamepad( void );

	private:
		void UpdateState( const DI_GAMEPAD_DATA* pData );
		void LostState( void );
		void RestoreState( void );
		UInt32 GetPovState( UInt32 index ) const;

	public:
		virtual void Update( void );
		virtual void Dispose( void );

	public:
		virtual UInt32 GetButtonState( UInt32 index ) const;
		virtual Float32 GetTriggerState( UInt32 index ) const;
		virtual const Mix::Vector2& GetStickState( UInt32 index ) const;
		virtual Boolean IsAvailable( void ) const;
		virtual Mix::HID::GAMEPAD_API GetAPI( void ) const;
		virtual UInt8 GetSourceButtonValue( UInt32 index ) const;
		virtual UInt32 GetSourcePovValue( UInt32 index ) const;
		virtual void SetButtonAssignment( UInt32 targetIndex, UInt32 sourceIndex );
		virtual UInt32 GetButtonAssignment( UInt32 targetIndex ) const;
		virtual void SetTriggerAssignment( UInt32 targetIndex, UInt32 sourceIndex );
		virtual UInt32 GetTriggerAssignment( UInt32 targetIndex ) const;
		virtual void SetTriggerThreshold( UInt32 index, UInt8 threshold );
		virtual UInt8 GetTriggerThreshold( UInt32 index ) const;
	};

}}}
