#include "Mix/Private/Graphics/DX9/TextureTargetL.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX9::TextureTargetL
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureTargetL* TextureTargetL::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												IDirect3DSurface9* pD3DSurface, D3DFORMAT d3dFormat )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureTargetL, pDevice, width, height, format, pD3DSurface, d3dFormat );
}

TextureTargetL::TextureTargetL(	Mix::Graphics::DX9::Device* pDevice,
								UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
								IDirect3DSurface9* pD3DSurface, D3DFORMAT d3dFormat ) :
DeviceObject( pDevice ),
m_pDevice( NULL ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_D3DFormat( d3dFormat ),
m_pD3DSurface( NULL )
{
	MIX_ASSERT( pDevice != NULL );
	MIX_ASSERT( pD3DSurface != NULL );

	MIX_ADD_REF( pDevice );
	m_pDevice = pDevice;

	m_pD3DSurface = pD3DSurface;
}

TextureTargetL::~TextureTargetL( void )
{
	MIX_RELEASE( m_pD3DSurface );
	MIX_RELEASE( m_pDevice );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

void TextureTargetL::Invalidate( void )
{
	MIX_RELEASE( m_pD3DSurface );
}

void TextureTargetL::Validate( void )
{
	MIX_ASSERT( m_pD3DSurface == NULL );

	HRESULT hRet;

	hRet = m_pDevice->CreateTargetSurface( m_Width, m_Height, m_D3DFormat, &m_pD3DSurface );
	if( hRet != D3D_OK )
	{
		MIX_LOG_ERROR( L"^[QbgeNX` ( Lockable ) ̕AɎs : CreateTargetSurface %s : Result[%s]",
			Mix::STR_RETERROR, m_pDevice->GetD3DResultText( hRet ) );
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

IDirect3DBaseTexture9* TextureTargetL::GetInterface( void )
{
	return NULL;
}

IDirect3DSurface9* TextureTargetL::GetSurface( UInt32 index )
{
	return m_pD3DSurface;
}

UInt32 TextureTargetL::GetSurfaceCount( void ) const
{
	return 1;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureTargetL::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_PLANE;
}

Mix::Graphics::ITexture::BIND_TYPE TextureTargetL::GetBindType( void ) const
{
	return ITexture::BIND_TARGET;
}

UInt32 TextureTargetL::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_CPU_READ | ITexture::ACCESS_GPU_WRITE;
}

UInt32 TextureTargetL::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureTargetL::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureTargetL::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureTargetL::GetFilePath( void ) const
{
	return Mix::STR_NULL;
}

Boolean TextureTargetL::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	if( ( m_pD3DSurface == NULL ) || ( m_bLock == True ) )
	{
		return False;
	}

	D3DLOCKED_RECT d3dLock;
	HRESULT hRet;

	hRet = m_pD3DSurface->LockRect( &d3dLock, NULL, D3DLOCK_READONLY );
	if( hRet != D3D_OK )
	{
		MIX_LOG_ERROR( L"^[QbgeNX` ( ( Lockable ) ) ̃bNɎs : LockRect %s : Result[%s]",
			Mix::STR_RETERROR, m_pDevice->GetD3DResultText( hRet ) );

		return False;
	}

	lock.pitch = static_cast<UInt32>( d3dLock.Pitch );
	lock.bits = d3dLock.pBits;

	m_bLock = True;

	return True;
}

void TextureTargetL::Unlock( void )
{
	if( ( m_pD3DSurface == NULL ) || ( m_bLock == False ) )
	{
		return;
	}

	HRESULT hRet;

	hRet = m_pD3DSurface->UnlockRect();
	if( hRet != D3D_OK )
	{
		MIX_LOG_ERROR( L"^[QbgeNX` ( Lockable ) ̃AbNɎs : UnlockRect %s : Result[%s]",
			Mix::STR_RETERROR, m_pDevice->GetD3DResultText( hRet ) );

		return;
	}

	m_bLock = False;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureTargetL::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
