#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Private/Graphics/DX9/Texture.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class TextureCube : public Mix::Graphics::DX9::Texture, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::TextureCube
		////////////////////////////////////////////////////////////////////////////////////////////////////

	private:
		static const D3DCUBEMAP_FACES D3DFACE_TABLE[Mix::Graphics::CUBEMAP_FACE_MAX];

	public:
		static TextureCube* CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
											const wchar_t* pFilePath,
											UInt32 edgeLength, Mix::Graphics::FORMAT format,
											D3DFORMAT d3dFormat, IDirect3DCubeTexture9* pD3DCubeTexture );

	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		Mix::String m_FilePath;
		UInt32 m_EdgeLength;
		Mix::Graphics::FORMAT m_Format;
		D3DFORMAT m_D3DFormat;
		IDirect3DCubeTexture9* m_pD3DCubeTexture;
		IDirect3DSurface9* m_pD3DSurface[Mix::Graphics::CUBEMAP_FACE_MAX];

	private:
		TextureCube(	Mix::Graphics::DX9::Device* pDevice,
						const wchar_t* pFilePath,
						UInt32 edgeLength, Mix::Graphics::FORMAT format,
						D3DFORMAT d3dFormat, IDirect3DCubeTexture9* pD3DCubeTexture );

		virtual ~TextureCube( void );

		void GetD3DCubeMapSurface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::Texture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual IDirect3DBaseTexture9* GetInterface( void );
		virtual IDirect3DSurface9* GetSurface( UInt32 index );
		virtual UInt32 GetSurfaceCount( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::ITexture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::ITexture::DIMENSION_TYPE GetDimensionType( void ) const;
		virtual Mix::Graphics::ITexture::BIND_TYPE GetBindType( void ) const;
		virtual UInt32 GetAccessFlags( void ) const;
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean Lock( Mix::Graphics::ITexture::LOCK& lock );
		virtual void Unlock( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};
}}}
