#include "Mix/Private/Graphics/DX9/Manager.h"

#include "Mix/Graphics/IVertexShader.h"
#include "Mix/Graphics/IPixelShader.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Manager : VF[_[
////////////////////////////////////////////////////////////////////////////////////////////////////

//LoX_[(VS)
static const UInt8 VS_CANVAS_3[] = {
	#include "Mix/Private/Graphics/Utility/DX9/Shader/3/canvas.vs.inc"
};

//LoX_[ - eNX`(PS)
static const UInt8 PS_CANVAS_COLOR_3[] = {
	#include "Mix/Private/Graphics/Utility/DX9/Shader/3/canvasColor.ps.inc"
};

//LoX_[ - eNX`L(PS)
static const UInt8 PS_CANVAS_COLOR_AND_TEXTURE_3[] = {
	#include "Mix/Private/Graphics/Utility/DX9/Shader/3/canvasColorAndTexture.ps.inc"
};

//C(VS)
static const UInt8 VS_LINE_3[] =
{
	#include "Mix/Private/Graphics/Utility/DX9/Shader/3/line.vs.inc"
};

//C(PS)
static const UInt8 PS_LINE_3[] =
{
	#include "Mix/Private/Graphics/Utility/DX9/Shader/3/line.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Manager
////////////////////////////////////////////////////////////////////////////////////////////////////

Manager* Manager::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, Manager );
}

Manager::Manager( void ) :
m_pDevice( NULL )
{
}

Manager::~Manager( void )
{
}

Boolean Manager::OnInitialize(	const Mix::Point& targetSize,
								Mix::Graphics::SHADER_MODEL shaderModel, Boolean bFullscreen, Boolean bWaitVSync,
								Mix::UserFile* pSysReport )
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// foCX̍쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_pDevice = Mix::Graphics::DX9::Device::CreateInstance( bWaitVSync );
	if( m_pDevice == NULL )
	{
		return False;
	}

	if( m_pDevice->Initialize( targetSize, shaderModel, bFullscreen, pSysReport ) == False )
	{
		return False;
	}

	return True;
}

void Manager::OnDispose( void )
{
	if( m_pDevice != NULL )
	{
		m_pDevice->Dispose();
		MIX_RELEASE( m_pDevice );
	}
}

void Manager::GetShaderBinary( Common::Manager::SHADER_TYPES type, Common::Manager::SHADER_BINARY& out )
{
	switch( type )
	{
	case Manager::SHADER_CANVAS_VS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"CanvasRenderer(DX9_3)" );
		out.pData = &( VS_CANVAS_3[0] );
		out.dataSize = sizeof( VS_CANVAS_3 );
		break;
	case Manager::SHADER_CANVAS_COLOR_PS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"CanvasRendererColor(DX9_3)" );
		out.pData = &( PS_CANVAS_COLOR_3[0] );
		out.dataSize = sizeof( PS_CANVAS_COLOR_3 );
		break;
	case Manager::SHADER_CANVAS_COLOR_AND_TEXTURE_PS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"CanvasRendererColorAndTexture(DX9_3)" );
		out.pData = &( PS_CANVAS_COLOR_AND_TEXTURE_3[0] );
		out.dataSize = sizeof( PS_CANVAS_COLOR_AND_TEXTURE_3 );
		break;

	case Manager::SHADER_LINE_VS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"Line(DX9_3)" );
		out.pData = &( VS_LINE_3[0] );
		out.dataSize = sizeof( VS_LINE_3 );
		break;
	case Manager::SHADER_LINE_PS:
		::wcscpy_s( out.name, Manager::SHADER_BINARY::NAME_SIZE, L"Line(DX9_3)" );
		out.pData = &( PS_LINE_3[0] );
		out.dataSize = sizeof( PS_LINE_3 );
		break;

	default:
		MIX_ERROR_W( L"w肳ꂽ풓VF[_[݂͑܂(SM3)" );
	};
}

Mix::Graphics::Common::Device* Manager::GetDevicePtr( void )
{
	return m_pDevice;
}

}}}
