#pragma once

#include <list>
#include <map>

#include "Mix/Module.h"
#include "Mix/Semaphore.h"
#include "Mix/CriticalSection.h"
#include "Mix/Private/Graphics/Common/Device.h"

namespace Mix{
	class UserFile;
}

namespace Mix{ namespace Graphics{ namespace DX9{

	class DeviceObject;
	class VertexLayout;
	class VertexShader;
	class PixelShader;
	class Texture2D;

	class Device : public Mix::Graphics::Common::Device
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::Device
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		struct PARAM
		{
			Boolean windowed;
			Boolean waitVSync;
		};

		static Device* CreateInstance( Boolean bWaitVSync );

	private:
		//Xe[^X
		enum STATUS
		{
			STATUS_OK					= 0,	//
			STATUS_CHANGE_WINDOW		= 1,
			STATUS_CHANGE_FULLSCREEN	= 2,
			STATUS_LOST					= 3,
		};

		//tO
		enum FLAG
		{
			FLAG_MODE_WINDOW			= 0x00000001,	//[h : EBhE
			FLAG_MODE_FULLSCREEN		= 0x00000002,	//[h : tXN[

			FLAG_RESOURCE_SURFACE		= 0x00000010,	//\[X : T[tFCX
			FLAG_RESOURCE_PLANE			= 0x00000020,	//\[X : v[
			FLAG_RESOURCE_VOLUME		= 0x00000040,	//\[X : {[
			FLAG_RESOURCE_CUBE			= 0x00000080,	//\[X : L[u
			FLAG_RESOURCE_DYNAMIC		= 0x00000100,	//\[X : _Ci~bN
			FLAG_RESOURCE_TARGET		= 0x00000200,	//\[X : ^[Qbg
			FLAG_RESOURCE_DEPTHSTENCIL	= 0x00000400,	//\[X : fvXXeV
		};

		//_[Xe[g^Cv
		enum RENDERSTATETYPE
		{
			RENDERSTATETYPE_FILLMODE			= 0,	//tB[h
			RENDERSTATETYPE_CULLMODE			= 1,	//JO[h
			RENDERSTATETYPE_SCISSORTESTENABLE	= 2,	//VU[eXg
			RENDERSTATETYPE_MULTISAMPLE			= 3,	//}`Tv
			RENDERSTATETYPE_ZENABLE				= 4,	//Zobt@
			RENDERSTATETYPE_ZWRITEENABLE		= 5,	//Zobt@̏
			RENDERSTATETYPE_ZFUNC				= 6,	//Zt@NV
			RENDERSTATETYPE_ALPHABLENDENABLE	= 7,	//At@uh
			RENDERSTATETYPE_SRCBLEND			= 8,	//uh[h(SrcColor)
			RENDERSTATETYPE_DESTBLEND			= 9,	//uh[h(DestColor)
			RENDERSTATETYPE_BLENDOP				= 10,	//uhIy[V(Color)
			RENDERSTATETYPE_SRCBLEND_ALPHA		= 11,	//uh[h(SrcAlpha)
			RENDERSTATETYPE_DESTBLEND_ALPHA		= 12,	//uh[h(DestAlpha)
			RENDERSTATETYPE_BLENDOP_ALPHA		= 13,	//uhIy[V(Alpha)
			RENDERSTATETYPE_WRITECOLOR			= 14,	//J[̏

			RENDERSTATETYPE_MAX					= 15,	//_[Xe[gő吔
		};

		//Tv[Xe[g^Cv
		enum SAMPLERSTATETYPE
		{
			SAMPLERSTATETYPE_MAGFILTER	= 0,	//gtB^[
			SAMPLERSTATETYPE_MINFILTER	= 1,	//ktB^[
			SAMPLERSTATETYPE_MIPFILTER	= 2,	//~bvtB^[
			SAMPLERSTATETYPE_ADDRESSU	= 3,	//UW̃AhbVO[h
			SAMPLERSTATETYPE_ADDRESSV	= 4,	//VW̃AhbVO[h
			SAMPLERSTATETYPE_ADDRESSW	= 5,	//WW̃AhbVO[h
			SAMPLERSTATETYPE_ANISOTROPY	= 6,	//ٕ

			SAMPLERSTATETYPE_MAX		= 7,	//Tv[Xe[gő吔
		};

		//foCXtH[}bg
		struct DEVFORMAT
		{
			UInt32 flag;
			UInt32 usage;
			D3DRESOURCETYPE resType;
		};

		//tH[}bg\
		struct FORMATINFO
		{
			D3DFORMAT	format;	//A_v^tH[}bg
			UInt32		flags;	//ΉĂ郊\[X( FLAG_SURFACE, FLAG_TEXTURE, FLAG_TARGET )
		};

		//foCXR{\
		struct DEVICECOMBO
		{
			UInt32		flags;
			D3DFORMAT	adapterFormat;
			D3DFORMAT	backBufferFormat;
			FORMATINFO	formatTable[Mix::Graphics::FMT_MAX];
		};

		//fBXvC[h̃\[gp\
		struct SORT_DISPLAYMODE
		{
			BOOL operator()( const D3DDISPLAYMODE& l, const D3DDISPLAYMODE& r ) const
			{
				if( l.Width > r.Width )
				{
					return FALSE;
				}
				if( l.Width < r.Width )
				{
					return TRUE;
				}
				if(	l.Height > r.Height )
				{
					return FALSE;
				}
				if( l.Height < r.Height )
				{
					return TRUE;
				}
				if( l.Format > r.Format )
				{
					return TRUE;
				}
				if( l.Format < r.Format )
				{
					return FALSE;
				}
				if( l.RefreshRate > r.RefreshRate )
				{
					return FALSE;
				}
				if( l.RefreshRate < r.RefreshRate )
				{
					return TRUE;
				}

				return FALSE;
			}
		};

		//foCXp[^
		struct DEVICEPARAM
		{
			struct
			{
				const FORMATINFO*		formatTable;			//tH[}bge[u
				Mix::Point				screenSize;				//XN[TCY
				D3DPRESENT_PARAMETERS	params;					//vZgp[^
			}current, next;
		};

		//^[QbgXe[g\
		struct TARGETSTATE
		{
			Mix::Rectangle rect;
			Mix::Graphics::ITexture* pTex[Mix::Graphics::TARGET_MAX];
			Mix::Graphics::ITexture* pDSTex;
		};

		//_[Xe[g\
		struct RENDERSTATE
		{
			D3DRENDERSTATETYPE type;
			UInt32 defValue;
			UInt32 value;
		};

		//Tv[Xe[g\
		struct SAMPLERSTATE
		{
			D3DSAMPLERSTATETYPE type;
			UInt32 defValue;
			UInt32 value;
		};

		//`Xe[g\
		struct DRAWSTATE
		{
			struct
			{
				Mix::Graphics::IVertexLayout* pVertexLayout;
				Mix::Graphics::IVertexShader* pVertexShader;
				Mix::Graphics::IPixelShader* pPixelShader;
				Mix::Graphics::IVertexBuffer* pVertexBuffer;
				Mix::Graphics::IIndexBuffer* pIndexBuffer;

			}current, next;

			Mix::Graphics::ITexture* textureTable[Mix::Graphics::TEXTURESTAGE_MAX];
		};

		//fBXvC[hXg
		typedef std::list<D3DDISPLAYMODE> DisplayModeList;
		//foCXR{Xg
		typedef std::list<DEVICECOMBO> DeviceComboList;

	private:
		Mix::Module m_D3D9Module;

		IDirect3D9* m_pD3D;
		IDirect3DDevice9* m_pD3DDevice;
		IDirect3DSurface9* m_pD3DBackBuffer;
		D3DCAPS9 m_Caps;

		DisplayModeList m_DisplayModeList;
		DeviceComboList	m_DeviceComboList;

		Mix::StringA m_VertexShaderProfile;
		Mix::StringA m_PixelShaderProfile;

		STATUS m_Status;
		DEVICEPARAM	m_DeviceParam;

		D3DVIEWPORT9 m_Viewport;
		Mix::Rectangle m_ViewportRect;
		Mix::Rectangle m_ScissorRect;

		Mix::Graphics::RASTERIZER_DESC m_RasterizeDesc;
		Mix::Graphics::DEPTH_DESC m_DepthDesc;
		Mix::Graphics::BLEND_DESC m_BlendDesc;

		TARGETSTATE m_TargetState;
		SAMPLERSTATE m_SamplerStateTable[Mix::Graphics::TEXTURESTAGE_MAX][SAMPLERSTATETYPE_MAX];
		RENDERSTATE	m_RenderStateTable[RENDERSTATETYPE_MAX];
		DRAWSTATE m_DrawState;

		Mix::Point m_TargetSize;
		Mix::Rectangle m_ScreenValidBounds;

		UInt32 m_DrawPrimitiveCount;

	private:
		Device( Boolean bWaitVSync );
		virtual ~Device( void );

		Boolean EnumDisplay( Mix::UserFile* pSysReport );

		Boolean CreatePresentation( Boolean bWindowed );
		void ChangePresentation( Boolean bWindowed );
		void ResetPresentation( void );
		void TracePresentation( const wchar_t* title );

		void ResetTargetState( void );
		void FlushTargetState( void );

		void ResetRenderState( void );
		void ResetRenderState( RENDERSTATETYPE type );
		void SetRenderState( RENDERSTATETYPE type, UInt32 value );

		void ResetSamplerState( void );
		void SetSamplerState( UInt32 slot, SAMPLERSTATETYPE type, UInt32 value );

		void ResetDrawState( void );
		void FlushDrawState( void );

		UInt32 ComputePrimitiveCount( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 num );

		void AdjustTexturePow2( UInt32& width, UInt32& height );
		void AdjustTextureSquare( UInt32& width, UInt32& height );

		const char* GetVertexShaderProfile( void );
		const char* GetPixelShaderProfile( void );

		void UpdateScreenValidRect( void );


	public:
		HRESULT CreateVertexBuffer( UInt32 count, UInt32 stride, Boolean bDynamic, IDirect3DVertexBuffer9** ppVertexBuffer );
		HRESULT CreateIndexBuffer( D3DFORMAT format, UInt32 count, Boolean bDynamic, IDirect3DIndexBuffer9** ppIndexBuffer );
		HRESULT CreateCubeTexture( UInt32 edgeLength, D3DFORMAT format, IDirect3DCubeTexture9** ppTexture );
		HRESULT CreateDynamicTexture( UInt32& width, UInt32& height, D3DFORMAT format, IDirect3DTexture9** ppTexture );
		HRESULT CreateTargetTexture( UInt32& width, UInt32& height, D3DFORMAT format, IDirect3DTexture9** ppTexture );
		HRESULT CreateTargetSurface( UInt32 width, UInt32 height, D3DFORMAT format, IDirect3DSurface9** ppSurface );
		HRESULT CreateDepthTexture( UInt32 width, UInt32 height, D3DFORMAT format, ::IDirect3DSurface9** ppSurface );
		HRESULT CreateQuery( Mix::Graphics::QUERY_FORMAT format, IDirect3DQuery9** ppQuery );

		static Mix::Graphics::FORMAT ConvertTextureFormat( D3DFORMAT d3dFormat );
		const wchar_t* GetD3DFormatText( D3DFORMAT format );
		const wchar_t* GetD3DResultText( HRESULT result );
		const wchar_t* GetQueryText( Mix::Graphics::QUERY_FORMAT format );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::Common::Device
		////////////////////////////////////////////////////////////////////////////////////////////////////

	private:
		Mix::Graphics::ITexture* CreatePlaneTexture(	const wchar_t* pFilePath,
														const Device::TEXTURE_DESC& desc,
														UInt32 subResourceCount,
														const Device::TEXTURE_SUBRESOURCE_DATA* subResources );

		Mix::Graphics::ITexture* CreateCubeTexture(		const wchar_t* pFilePath,
														const Device::TEXTURE_DESC& desc,
														UInt32 subResourceCount,
														const Device::TEXTURE_SUBRESOURCE_DATA* subResources );

		Mix::Graphics::ITexture* CreateVolumeTexture(	const wchar_t* pFilePath,
														const Device::TEXTURE_DESC& desc,
														UInt32 subResourceCount,
														const Device::TEXTURE_SUBRESOURCE_DATA* subResources );

		static void CopyTexture_R8G8B8A8( void* pDst, UInt32 destPitch, const void* pSrc, UInt32 srcSize, UInt32 srcPitch );

	protected:
		virtual void OnDispose( void );

		virtual Mix::Graphics::ITexture* OnCreateTexture(	const wchar_t* pFilePath,
															const Device::TEXTURE_DESC& desc,
															UInt32 subResourceCount,
															const Device::TEXTURE_SUBRESOURCE_DATA* subResources );
	public:
		virtual Boolean Initialize( const Mix::Point& targetSize, Mix::Graphics::SHADER_MODEL shaderModel, Boolean bFullscreen, Mix::UserFile* pSysReport );
		virtual Boolean Update( void );
		virtual Boolean MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDevice
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::SHADER_MODEL GetShaderModel( void ) const;

		virtual Mix::Graphics::IDevice::DISPLAY_MODE GetDisplayMode( void ) const;
		virtual void SetDisplayMode( Mix::Graphics::IDevice::DISPLAY_MODE dispMode );
		virtual void ToggleDisplayMode( void );

		virtual const Mix::Point& GetScreenSize( void ) const;
		virtual const Mix::Rectangle& GetScreenValidBounds( void ) const;

		virtual Boolean IsHullShaderSupported( void ) const;
		virtual Boolean IsDomainShaderSupported( void ) const;
		virtual Boolean IsGeometryShaderSupported( void ) const;
		virtual Boolean IsShaderConstantSupported( void ) const;
		virtual Boolean IsIndexSupported( Mix::Graphics::INDEX_FORMAT format ) const;
		virtual Boolean IsPlaneTextureSupported( Mix::Graphics::FORMAT format ) const;
		virtual Boolean IsVolumeTextureSupported( Mix::Graphics::FORMAT format ) const;
		virtual Boolean IsCubeTextureSupported( Mix::Graphics::FORMAT format ) const;
		virtual Boolean IsDynamicPlaneTextureSupported( Mix::Graphics::FORMAT format ) const;
		virtual Boolean IsTargetPlaneTextureSupported( Mix::Graphics::FORMAT format ) const;
		virtual Boolean IsLockableTargetPlaneTextureSupported( Mix::Graphics::FORMAT format ) const;
		virtual Boolean IsTargetCubeTextureSupported( Mix::Graphics::FORMAT format ) const;
		virtual Boolean IsDepthTextureSupported( Mix::Graphics::FORMAT format ) const;

		virtual Boolean CreateHullShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IHullShader** ppHullShader );
		virtual Boolean CreateHullShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IHullShader** ppHullShader, const wchar_t* pDebugName );
		virtual Boolean CreateDomainShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IDomainShader** ppDomainShader );
		virtual Boolean CreateDomainShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IDomainShader** ppDomainShader, const wchar_t* pDebugName );
		virtual Boolean CreateGeometryShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IGeometryShader** ppGeometryShader );
		virtual Boolean CreateGeometryShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IGeometryShader** ppGeometryShader, const wchar_t* pDebugName );
		virtual Boolean CreateVertexShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IVertexShader** ppVertexShader );
		virtual Boolean CreateVertexShaderFromMemory( const void* pSrcData, UInt32 srcDataSize, Mix::Graphics::IVertexShader** ppVertexShader, const wchar_t* pDebugName );
		virtual Boolean CreatePixelShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IPixelShader** ppPixelShader );
		virtual Boolean CreatePixelShaderFromMemory( const void* pSrcData, UInt32 srcDataSize, Mix::Graphics::IPixelShader** ppPixelShader, const wchar_t* pDebugName );

		virtual Boolean CreateShaderConstant( UInt32 size, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IShaderConstant** ppShaderConstant, const wchar_t* pDebugName );

		virtual Boolean CreateVertexLayout( const Mix::Graphics::VERTEX_ELEMENT* pElements, UInt32 numElement, const Mix::Graphics::IVertexShader* pVertexShader, Mix::Graphics::IVertexLayout** ppVertexLayout, const wchar_t* pName );
		virtual Boolean CreateVertexBuffer( UInt32 count, UInt32 stride, Boolean bDynamic, UInt32 resizeStep, const void* pInitialData, Mix::Graphics::IVertexBuffer** ppVertexBuffer, const wchar_t* pDebugName );
		virtual Boolean CreateIndexBuffer( Mix::Graphics::INDEX_FORMAT format, UInt32 count, Boolean bDynamic, UInt32 resizeStep, const void* pInitialData, Mix::Graphics::IIndexBuffer** ppIndexBuffer, const wchar_t* pDebugName );

		virtual Boolean CreateTextureFromFile( const wchar_t* pFilePath, Mix::Graphics::ITexture** ppTexture );
		virtual Boolean CreateTextureFromMemory( const wchar_t* pFilePath, const void* pSrc, UInt32 srcSize, Mix::Graphics::ITexture** ppTexture );
		virtual Boolean CreateDynamicPlaneTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName );
		virtual Boolean CreateTargetPlaneTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName );
		virtual Boolean CreateLockableTargetPlaneTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName );
		virtual Boolean CreateTargetCubeTexture( UInt32 edgeLength, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName );
		virtual Boolean CreateDepthTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName );

		virtual Boolean CreateQuery( Mix::Graphics::QUERY_FORMAT format, Mix::Graphics::IQuery** ppQuery, const wchar_t* pDebugName );

		virtual Boolean Begin( void );
		virtual void End( void );
		virtual void Present( void );

		virtual void SetTarget( Mix::Graphics::ITexture* pT0, Mix::Graphics::ITexture* pT1, Mix::Graphics::ITexture* pT2, Mix::Graphics::ITexture* pT3, Mix::Graphics::ITexture* pDS );
		virtual void GetTarget( Mix::Graphics::ITexture** ppT0, Mix::Graphics::ITexture** ppT1, Mix::Graphics::ITexture** ppT2, Mix::Graphics::ITexture** ppT3, Mix::Graphics::ITexture** ppDS );

		virtual const Mix::Rectangle& GetViewBounds( void ) const;
		virtual void SetViewBounds( const Mix::Rectangle& rect );
		virtual void SetViewBounds( Int32 x, Int32 y, Int32 width, Int32 height );

		virtual const Mix::Rectangle& GetScissorBounds( void ) const;
		virtual void SetScissorBounds( const Mix::Rectangle& rect );
		virtual void SetScissorBounds( Int32 x, Int32 y, Int32 width, Int32 height );

		virtual void Clear( Boolean clearTarget, Boolean clearDepth, const Mix::Vector4& color, Float32 z );

		virtual void SetRasterizerState( Mix::Graphics::FILL_TYPE fillMode, Mix::Graphics::CULL_TYPE cullMode, Boolean bScissoring );
		virtual void SetRasterizerState( const Mix::Graphics::RASTERIZER_DESC& state );
		virtual const Mix::Graphics::RASTERIZER_DESC& GetRasterizerState( void ) const;

		virtual void SetDepthState( Boolean bTest, Boolean bWrite, Mix::Graphics::ZFUNC_TYPE func );
		virtual void SetDepthState( const Mix::Graphics::DEPTH_DESC& state );
		virtual const Mix::Graphics::DEPTH_DESC& GetDepthState( void ) const;

		virtual void SetBlendState( Mix::Graphics::BLEND_TYPE type, Mix::Graphics::COLOR_WRITE_MASK colorWriteMask );
		virtual void SetBlendState( const Mix::Graphics::BLEND_DESC& desc );
		virtual const Mix::Graphics::BLEND_DESC& GetBlendState( void ) const;

		virtual void SetVertexLayout( Mix::Graphics::IVertexLayout* pVertexLayout );

		virtual void SetHullShader( Mix::Graphics::IHullShader* pHullShader );
		virtual void SetDomainShader( Mix::Graphics::IDomainShader* pDomainShader );
		virtual void SetGeometryShader( Mix::Graphics::IGeometryShader* pGeometryShader );
		virtual void SetVertexShader( Mix::Graphics::IVertexShader* pVertexShader );
		virtual void SetPixelShader( Mix::Graphics::IPixelShader* pPixelShader );

		virtual void SetVertexShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count );
		virtual void SetVertexShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count );
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count );
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count );
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count );
		virtual void SetPixelShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count );
		virtual void SetPixelShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count );
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count );
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count );
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count );

		virtual void SetHullShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetDomainShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetGeometryShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetVertexShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );
		virtual void SetPixelShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant );

		virtual void SetVertexBuffer( Mix::Graphics::IVertexBuffer* pVertexBuffer );
		virtual void SetIndexBuffer( Mix::Graphics::IIndexBuffer* pIndexBuffer );

		virtual UInt32 GetTextureStageMax( void ) const;
		virtual void SetTexture( UInt32 stage, Mix::Graphics::TEXTURE_FILTER_TYPE filter, Mix::Graphics::TEXTURE_ADDRESS_TYPE address, Mix::Graphics::ITexture* pTexture );
		virtual void ResetTexture( UInt32 stage );

		virtual void Draw( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex );
		virtual void DrawIndexed( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex, UInt32 startIndex, UInt32 numIndex );

		virtual UInt32 GetDrawPrimitiveCount( void ) const;

		virtual Boolean SaveScreenshot( const wchar_t* pFileName );

	private:
		static const char* VS_UNKNOWN;
		static const char* VS_1_1;
		static const char* VS_2_A;
		static const char* VS_2_0;
		static const char* VS_3_0;

		static const char* PS_UNKNOWN;
		static const char* PS_1_1;
		static const char* PS_1_2;
		static const char* PS_1_3;
		static const char* PS_1_4;
		static const char* PS_2_A;
		static const char* PS_2_B;
		static const char* PS_2_0;
		static const char* PS_3_0;

		//D3D : o[ebNXCAEg̃Z}eBbN^Cve[u
		static const UInt8 D3DVLSemanticTypeTable[Mix::Graphics::VERTEX_ELEMENT_SEMANTIC_MAX];
		//D3D : o[ebNXCXg̃tH[}bge[u
		static const UInt8 D3DVLFormatTable[Mix::Graphics::VERTEX_ELEMENT_FORMAT_MAX];
		//D3D : tH[}bgeLXgz
		static const wchar_t* D3DFormatTextArray[20];
		//D3D : UgeLXgz
		static const wchar_t* D3DResultTextArray[6];
		//D3D : JO[he[u
		const static UInt32 D3DCullModeTable[3];
		//D3D : Zt@NVe[u
		const static UInt32 D3DZFuncTable[Mix::Graphics::ZFUNC_MAX];
		//D3D : v~eBu^Cve[u
		static const D3DPRIMITIVETYPE D3DPrimitiveTypeTable[Mix::Graphics::PT_MAX];
		//D3D : NG^Cve[u
		static const D3DQUERYTYPE D3DQueryTypeTable[Mix::Graphics::QT_MAX];
		//D3D : NGe[u
		static const wchar_t* D3DQueryTextTable[Mix::Graphics::QT_MAX];

		//D3D : L[ueNX`tFCXe[u
		static const D3DCUBEMAP_FACES D3DCubeFaceTable[6];
		static const UInt32 D3DCubeFaceCount;
	};

}}}
