#include "Mix/Private/Graphics/DX11/VertexShader.h"
#include "Mix/Private/Graphics/DX11/Device.h"
#include "Mix/Memory/IBuffer.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::VertexShader
////////////////////////////////////////////////////////////////////////////////////////////////////

VertexShader* VertexShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11VertexShader* pVertexShader, Mix::Memory::IBuffer* pInputSignature )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, VertexShader, pDevice, pVertexShader, pInputSignature );
}

VertexShader::VertexShader( Mix::Graphics::DX11::Device* pDevice, ID3D11VertexShader* pVertexShader, Mix::Memory::IBuffer* pInputSignature ) :
DeviceObject( pDevice ),
m_pVertexShader( pVertexShader ),
m_pInputSignature( pInputSignature )
{
}

VertexShader::~VertexShader( void )
{
	MIX_RELEASE( m_pInputSignature );
	MIX_RELEASE( m_pVertexShader );
}

ID3D11VertexShader* VertexShader::GetInterface( void )
{
	return m_pVertexShader;
}

const void* VertexShader::GetInputSignature( void ) const
{
	return m_pInputSignature->GetConstPointer();
}

UIntT VertexShader::GetInputSignatureSize( void ) const
{
	return m_pInputSignature->GetSize();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE VertexShader::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::VERTEX_SHADER;
}

}}}
