#include "Mix/Private/Graphics/DX11/VertexLayout.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::VertexLayout
////////////////////////////////////////////////////////////////////////////////////////////////////

VertexLayout* VertexLayout::CreateInstance( Mix::Graphics::DX11::Device* pDevice,
											ID3D11InputLayout* pVertexLayout,
											const Mix::Graphics::VERTEX_ELEMENT* pElements,
											UInt32 elementCount,
											UInt32 stride )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, VertexLayout, pDevice, pVertexLayout, pElements, elementCount, stride );
}

VertexLayout::VertexLayout( Mix::Graphics::DX11::Device* pDevice,
							ID3D11InputLayout* pVertexLayout,
							const Mix::Graphics::VERTEX_ELEMENT* pElements,
							UInt32 elementCount,
							UInt32 stride ) :
DeviceObject( pDevice ),
m_pVertexLayout( pVertexLayout ),
m_ElementSemanticFlags( 0 ),
m_Stride( stride )
{
	m_ElementList.reserve( elementCount );

	for( UInt32 i = 0; i < elementCount; i++ )
	{
		m_ElementList.push_back( pElements[i] );
		MIX_SETBIT( m_ElementSemanticFlags, ( 1 << pElements[i].semanticType ) );
	}
}

VertexLayout::~VertexLayout( void )
{
	MIX_RELEASE( m_pVertexLayout );
}

ID3D11InputLayout* VertexLayout::GetInterface( void )
{
	return m_pVertexLayout;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IVertexBuffer
////////////////////////////////////////////////////////////////////////////////////////////////////

UInt32 VertexLayout::GetElementCount( void ) const
{
	return MIX_UIT_TO_UI32( m_ElementList.size() );
}

const Mix::Graphics::VERTEX_ELEMENT* VertexLayout::GetElements( void ) const
{
	return &( m_ElementList[0] );
}

UInt32 VertexLayout::GetElementSemanticFlags( void ) const
{
	return m_ElementSemanticFlags;
}

UInt32 VertexLayout::GetStride( void ) const
{
	return m_Stride;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE VertexLayout::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::VERTEX_LAYOUT;
}

}}}
