#pragma once

#include "Mix/Private/Graphics/DX11/Texture.h"
#include "Mix/Private/Graphics/Common/DeviceObject.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class TextureDepth : public Mix::Graphics::DX11::Texture, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::TextureDepth
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static TextureDepth* CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												ID3D11Texture2D* pTexture, ID3D11DepthStencilView* pDSView );

	private:
		UInt32 m_Width;
		UInt32 m_Height;
		Mix::Graphics::FORMAT m_Format;
		ID3D11Texture2D* m_pTexture;
		ID3D11DepthStencilView* m_pDSView;

	private:
		TextureDepth(	Mix::Graphics::DX11::Device* pDevice,
						UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						ID3D11Texture2D* pTexture, ID3D11DepthStencilView* pDSView );

		virtual ~TextureDepth( void );

	public:
		ID3D11DepthStencilView* GetDSView( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::Texture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual ID3D11Resource* GetInterface( void );
		virtual ID3D11ShaderResourceView* GetSRView( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::ITexture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::ITexture::DIMENSION_TYPE GetDimensionType( void ) const;
		virtual Mix::Graphics::ITexture::BIND_TYPE GetBindType( void ) const;
		virtual UInt32 GetAccessFlags( void ) const;
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean Lock( Mix::Graphics::ITexture::LOCK& lock );
		virtual void Unlock( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
