#include "Mix/Private/Graphics/DX11/TextureDepth.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::TextureDepth
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureDepth* TextureDepth::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
											UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											ID3D11Texture2D* pTexture, ID3D11DepthStencilView* pDSView )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureDepth, pDevice, width, height, format, pTexture, pDSView );
}

TextureDepth::TextureDepth(	Mix::Graphics::DX11::Device* pDevice,
							UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
							ID3D11Texture2D* pTexture, ID3D11DepthStencilView* pDSView ) :
DeviceObject( pDevice ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pDSView( pDSView )
{
	MIX_ASSERT( pTexture != NULL );
	MIX_ASSERT( pDSView != NULL );
}

TextureDepth::~TextureDepth( void )
{
	MIX_RELEASE( m_pDSView );
	MIX_RELEASE( m_pTexture );
}

ID3D11DepthStencilView* TextureDepth::GetDSView( void )
{
	return m_pDSView;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

ID3D11Resource* TextureDepth::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TextureDepth::GetSRView( void )
{
	return NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureDepth::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_PLANE;
}

Mix::Graphics::ITexture::BIND_TYPE TextureDepth::GetBindType( void ) const
{
	return Mix::Graphics::ITexture::BIND_DEPTH;
}

UInt32 TextureDepth::GetAccessFlags( void ) const
{
	return Mix::Graphics::ITexture::ACCESS_GPU_WRITE;
}

UInt32 TextureDepth::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureDepth::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureDepth::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureDepth::GetFilePath( void ) const
{
	return Mix::STR_NULL;
}

Boolean TextureDepth::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TextureDepth::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureDepth::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
