#include "Mix/Private/Graphics/DX11/Query.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::Query
////////////////////////////////////////////////////////////////////////////////////////////////////

Query* Query::CreateInstance( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::QUERY_FORMAT format, ID3D11Query* pD3DQuery )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, Query, pDevice, format, pD3DQuery );
}

Query::Query( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::QUERY_FORMAT format, ID3D11Query* pD3DQuery ) :
DeviceObject( pDevice ),
m_pDevice( pDevice ),
m_Format( format ),
m_pD3DQuery( pD3DQuery )
{
	MIX_ADD_REF( m_pDevice );
}

Query::~Query( void )
{
	MIX_RELEASE( m_pD3DQuery );
	MIX_RELEASE( m_pDevice );
}

void Query::Begin( void )
{
	m_pDevice->BeginQuery( m_pD3DQuery );
}

void Query::End( void )
{
	m_pDevice->EndQuery( m_pD3DQuery );
}

Boolean Query::GetData( UInt32& data, Boolean bFlush ) const
{
	HRESULT ret;

	ret = m_pDevice->GetQueryData( m_pD3DQuery, bFlush, data );
	if( ret != S_OK )
	{
		return False;
	}

	return True;
}

Mix::Graphics::QUERY_FORMAT Query::GetFormat( void ) const
{
	return m_Format;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE Query::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::QUERY;
}

}}}
