#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IPixelShader.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class PixelShader : public Mix::Graphics::IPixelShader, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::PixelShader
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static PixelShader* CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader );

	private:
		ID3D11PixelShader* m_pPixelShader;

	private:
		PixelShader( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader );
		virtual ~PixelShader( void );

	public:
		ID3D11PixelShader* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
