#include "Mix/Private/Graphics/DX11/PixelShader.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::PixelShader
////////////////////////////////////////////////////////////////////////////////////////////////////

PixelShader* PixelShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, PixelShader, pDevice, pPixelShader );
}

PixelShader::PixelShader( Mix::Graphics::DX11::Device* pDevice, ID3D11PixelShader* pPixelShader ) :
DeviceObject( pDevice ),
m_pPixelShader( pPixelShader )
{
}

PixelShader::~PixelShader( void )
{
	MIX_RELEASE( m_pPixelShader );
}

ID3D11PixelShader* PixelShader::GetInterface( void )
{
	return m_pPixelShader;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE PixelShader::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::PIXEL_SHADER;
}

}}}
