#pragma once

#include "Mix/Dynamics/ISensor.h"
#include "Mix/Private/Dynamics/Object.h"

namespace Mix{ namespace Dynamics{

	class ObjectContext;

	class Sensor : public Mix::Dynamics::ISensor, public Mix::Dynamics::Object
	{
	public:
		static Sensor* CreateInstance( Mix::Dynamics::IShape* pShape );

	private:
		UInt16 m_FilterGroup;
		UInt16 m_FilterMask;
		Mix::Dynamics::IShape* m_pShape;
		Mix::Dynamics::ObjectContext* m_pContext;
		btDefaultMotionState* m_pMotionState;
		btRigidBody* m_pObject;

		Int32 m_UserIndex;
		void* m_pUserPtr;

	private:
		Sensor( Mix::Dynamics::IShape* pShape );
		virtual ~Sensor( void );

	public:
		Boolean Initialize( const wchar_t* pDebugName );

	public:
		virtual Mix::Dynamics::ObjectContext* GetContextPtr( void ) const;

		virtual btCollisionObject* Bullet_GetCollisionObjectPtr( void ) const;
		virtual btRigidBody* Bullet_GetRigidBodyPtr( void ) const;

	public:
		virtual Mix::Dynamics::IObject::TYPE GetType( void ) const;

		virtual Boolean GetShape( Mix::Dynamics::IShape** ppShape );

		virtual Float32 GetShapeMargin( void ) const;
		virtual void SetShapeMargin( Float32 margin );

		virtual UInt16 GetFilterGroup( void ) const;
		virtual void SetFilterGroup( UInt16 filterGroup );

		virtual UInt16 GetFilterMask( void ) const;
		virtual void SetFilterMask( UInt16 filterMask );

		virtual const Mix::Dynamics::MATERIAL& GetMaterial( void ) const;
		virtual void SetMaterial( const Mix::Dynamics::MATERIAL& material );

		virtual Mix::Quaternion GetWorldRotation( void ) const;
		virtual Mix::Vector3 GetWorldPosition( void ) const;
		virtual Mix::Matrix4x4 GetWorldMatrix( void ) const;

		virtual void SetWorldRotation( const Mix::Quaternion& rotation );
		virtual void SetWorldPosition( const Mix::Vector3& pos );
		virtual void SetWorldTransform( const Mix::Quaternion& rot, const Mix::Vector3& pos );

		virtual Boolean IsInWorld( void ) const;

		virtual Mix::Geometry::AABB GetBounds( void ) const;

		virtual Boolean AddListener( Mix::Dynamics::IObjectListener* pListener );
		virtual void RemoveListener( Mix::Dynamics::IObjectListener* pListener );

		virtual Int32 GetUserIndex( void ) const;
		virtual void SetUserIndex( Int32 index );

		virtual void* GetUserPtr( void ) const;
		virtual void SetUserPtr( void* pData );

		virtual UInt32 Debug_GetDrawFlags( void ) const;
		virtual void Debug_SetDrawFlags( UInt32 flags );

		virtual Float32 Debug_GetDrawAxisScaling( void ) const;
		virtual void Debug_SetDrawAxisScaling( Float32 scaling );

		virtual void Debug_Draw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer, Float32 opacity );

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}
