#include "Mix/Private/Dynamics/CylinderShape.h"

#include "Mix/Graphics/Utility/IPerspectiveRenderer.h"

namespace Mix{ namespace Dynamics{

CylinderShape* CylinderShape::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_DYNAMICS, CylinderShape );
}

CylinderShape::CylinderShape( void ) :
m_Axis( Mix::Dynamics::AXIS_Y ),
m_Height( 0.0f ),
m_Radius( 0.0f ),
m_pObject( NULL )
{
}

CylinderShape::~CylinderShape( void )
{
	MIX_LIB_DELETE( m_pObject );
}

Boolean CylinderShape::Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 height, Float32 radius )
{
	Float32 halfHeight = height * 0.5f;

	m_Axis = axis;
	m_Height = height;
	m_Radius = radius;

	switch( m_Axis )
	{
	case Mix::Dynamics::AXIS_X:
		m_pObject = MIX_LIB_NEW ::btCylinderShapeX( btVector3( halfHeight, radius, 0.0f ) );
		break;
	case Mix::Dynamics::AXIS_Y:
		m_pObject = MIX_LIB_NEW ::btCylinderShape( btVector3( radius, halfHeight, 0.0f ) );
		break;
	case Mix::Dynamics::AXIS_Z:
		m_pObject = MIX_LIB_NEW ::btCylinderShapeZ( btVector3( radius, 0.0f, halfHeight ) );
		break;
	}

	if( m_pObject == NULL )
	{
		return False;
	}

	Shape::Bullet_SetCollisionShape( m_pObject );

	return True;
}

btConvexShape* CylinderShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Mix::Dynamics::AXIS_TYPE CylinderShape::GetAxis( void ) const
{
	return m_Axis;
}

Float32 CylinderShape::GetHeight( void ) const
{
	return m_Height;
}

Float32 CylinderShape::GetRadius( void ) const
{
	return m_Radius;
}

Mix::Dynamics::IShape::TYPE CylinderShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::CYLINDER;
}

Float32 CylinderShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void CylinderShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void CylinderShape::DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer )
{
	if( pPerspectiveRenderer != NULL )
	{
		pPerspectiveRenderer->AddCylinder( m_Axis, GetHeight(), GetRadius() );
	}
}

}}

