#pragma once

#include "Mix/Dynamics/ICapsuleShape.h"
#include "Mix/Private/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

	class CapsuleShape : public Mix::Dynamics::ICapsuleShape, public Mix::Dynamics::Shape
	{
	public:
		static CapsuleShape* CreateInstance( void );

	private:
		Mix::Dynamics::AXIS_TYPE m_Axis;
		Float32 m_Height;
		btCapsuleShape* m_pObject;

	private:
		CapsuleShape( void );
		virtual ~CapsuleShape( void );

	public:
		Boolean Initialize( Mix::Dynamics::AXIS_TYPE axis, Float32 axisLength, Float32 radius );

	public:
		virtual btConvexShape* Bullet_GetConvexShapePtr( void ) const;

	public:
		virtual Mix::Dynamics::AXIS_TYPE GetAxis( void ) const;
		virtual Float32 GetHeight( void ) const;
		virtual Float32 GetRadius( void ) const;

	public:
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const;

		virtual Float32 GetMargin( void ) const;
		virtual void SetMargin( Float32 margin );

		virtual void DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer );
	};

}}
